package com.biz.crm.common.captcha.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.awt.*;
import java.io.Serializable;
import java.util.List;

/**
 * 请求获取图片底图及滑块图片数据Dto类
 *
 * @author zwb
 * @date 2021-09-27
 */
@ApiModel(value = "CaptchaDto", description = "该DTO负责传输获取图片底图及滑块图片数据")
public class CaptchaDto implements Serializable {

  /**
   * 验证码id(后台申请)
   */
  @ApiModelProperty("验证码id(后台申请)")
  private String captchaId;

  /**
   * 原生图片base64
   */
  @ApiModelProperty("原生图片base64")
  private String originalImageBase64;

  /**
   * 滑块图片base64
   */
  @ApiModelProperty("滑块图片base64")
  private String jigsawImageBase64;

  /**
   * 滑块点选坐标
   */
  @ApiModelProperty("滑块点选坐标")
  private PointDto point;

  /**
   * 点坐标(base64加密传输)
   */
  @ApiModelProperty("点坐标(base64加密传输)")
  private String pointJson;

  /**
   * UUID(每次请求的验证码唯一标识)
   */
  @ApiModelProperty("UUID(每次请求的验证码唯一标识)")
  private String token;

  /**
   * 校验结果
   */
  @ApiModelProperty("校验结果")
  private Boolean result = false;

  /**
   * 后台二次校验参数
   */
  @ApiModelProperty("后台二次校验参数")
  private String captchaVerification;

  /***
   * 客户端标识 clientUniqueId 用于标识每台请求的设备
   */
  @ApiModelProperty("客户端标识 clientUniqueId 用于标识每台请求的设备")
  private String clientUniqueId;

  /**
   * 点选文字
   */
  @ApiModelProperty("点选文字")
  private List<String> wordList;

  /**
   * 点选坐标
   */
  @ApiModelProperty("点选坐标")
  private List<Point> pointList;

  /**
   * 用户标识
   */
  @ApiModelProperty("用户标识")
  private String account;

  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public void resetClientFlag() {
    this.clientUniqueId = null;
  }

  public String getCaptchaId() {
    return captchaId;
  }

  public void setCaptchaId(String captchaId) {
    this.captchaId = captchaId;
  }

  public String getOriginalImageBase64() {
    return originalImageBase64;
  }

  public void setOriginalImageBase64(String originalImageBase64) {
    this.originalImageBase64 = originalImageBase64;
  }

  public String getJigsawImageBase64() {
    return jigsawImageBase64;
  }

  public void setJigsawImageBase64(String jigsawImageBase64) {
    this.jigsawImageBase64 = jigsawImageBase64;
  }

  public PointDto getPoint() {
    return point;
  }

  public void setPoint(PointDto point) {
    this.point = point;
  }

  public String getPointJson() {
    return pointJson;
  }

  public void setPointJson(String pointJson) {
    this.pointJson = pointJson;
  }

  public String getToken() {
    return token;
  }

  public void setToken(String token) {
    this.token = token;
  }

  public Boolean getResult() {
    return result;
  }

  public void setResult(Boolean result) {
    this.result = result;
  }

  public String getCaptchaVerification() {
    return captchaVerification;
  }

  public void setCaptchaVerification(String captchaVerification) {
    this.captchaVerification = captchaVerification;
  }

  public String getClientUniqueId() {
    return clientUniqueId;
  }

  public void setClientUniqueId(String clientUniqueId) {
    this.clientUniqueId = clientUniqueId;
  }

  public List<String> getWordList() {
    return wordList;
  }

  public void setWordList(List<String> wordList) {
    this.wordList = wordList;
  }

  public List<Point> getPointList() {
    return pointList;
  }

  public void setPointList(List<Point> pointList) {
    this.pointList = pointList;
  }
}