package com.biz.crm.common.captcha.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 点位dto，用于接收传递点位信息
 *
 * @author zwb
 * @date 2021-09-27
 */
@ApiModel(value = "PointDto", description = "该DTO负责接收传递点位信息")
public class PointDto implements Serializable {

  private static final long serialVersionUID = 6372255530844801364L;
  /**
   * x坐标
   */
  @ApiModelProperty("x坐标")
  public int x;

  /**
   * y坐标
   */
  @ApiModelProperty("y坐标")
  public int y;


  public int getX() {
    return x;
  }

  public void setX(int x) {
    this.x = x;
  }

  public int getY() {
    return y;
  }

  public void setY(int y) {
    this.y = y;
  }

  public PointDto(int x, int y) {
    this.x = x;
    this.y = y;
  }

}
