package com.biz.crm.common.captcha.sdk.service;

import java.util.concurrent.TimeUnit;

/**
 * 验证码缓存接口
 *
 * @author zwb
 * @date 2021-09-27
 */
public interface CaptchaCacheService {

  /**
   * 设置缓存值
   *
   * @param key              键
   * @param value            需要存储的值
   * @param expiresInSeconds 过期时间 秒
   * @param clientUniqueId 客户端唯一标识
   */
  void setMCode(String key, String value, long expiresInSeconds, String clientUniqueId);

  /**
   * 判断是否存在这个key
   *
   * @param key
   * @param clientUniqueId 客户端唯一标识
   * @return true存在 false 不存在
   */
  boolean existsMCode(String key, String clientUniqueId);

  /**
   * 删除某个key
   *
   * @param key
   * @param clientUniqueId 客户端唯一标识
   * @return
   */
  void deleteMCode(String key, String clientUniqueId);

  /**
   * 获取key对应值
   * @param key
   * @param clientUniqueId 客户端唯一标识
   * @return
   * 有两种情况会返回null：mapName对应的虚拟map结构中，并没有设定指定的key值；另一种是之前设定了，但是已经到了有效期
   */
  String getMCode(String key, String clientUniqueId);


  /**
   * 根据编码从redis获取一个自增长的数字，并且设置一个过期时间
   * @param code 键
   * @param min 最小值 如果获取的值小于最小值就直接返回最小值
   * @param expire 过期时间
   * @param unit 过期单位
   * @return
   */
  Long getAndIncrement(String code, long min, long expire, TimeUnit unit);

  /**
   * 获取当前自增的数据,如果没有则返回null
   *
   * @param code 键
   * @return
   */
  Long getIncrement(String code);

  /**
   * 使用Redis客户端，在服务器完成一次原子性质的获取和增加操作
   *
   * @param code key键值
   * @param min 最小值 如果获取的值小于最小值就直接返回最小值
   * @return
   */
  long getAndIncrement(String code, long min);
}
