package com.biz.crm.common.captcha.sdk.service;


import com.biz.crm.common.captcha.sdk.dto.CaptchaDto;

/**
 * 验证码服务接口
 *
 * @author zwb
 * @date 2021-09-27
 */
public interface CaptchaService {

  /**
   * 获取验证码
   *
   * @param captchaDto
   * @return
   */
  CaptchaDto getCaptcha(CaptchaDto captchaDto);

  /**
   * 核对验证码(前端)
   *
   * @param captchaDto
   * @return
   */
  CaptchaDto checkCaptcha(CaptchaDto captchaDto);


  /**
   * 二次校验验证码
   *
   * @param captchaVerification 二次校验码
   * @param clientUniqueId           用户唯一标识
   * @return
   */
  void verificationCaptcha(String captchaVerification, String clientUniqueId);
}
