package com.biz.crm.common.sequese.local.generator.service;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import com.biz.crm.common.sequese.sdk.generator.service.CrmSequeseGenerator;
import lombok.extern.slf4j.Slf4j;

/**
 * 算法初始化
 * 
 * @author Ken.xu
 *
 */
@Slf4j
@Component
public class InitCrmSequeseGenerator {

  @Autowired
  public void init(List<CrmSequeseGenerator<?>> generatorList) {
    int idx = 0;
    for (CrmSequeseGenerator<?> crmSequeseGenerator : generatorList) {
      idx++;
      try {
        crmSequeseGenerator.initAlgorithm();
        log.info("{}、算法初始化-成功:{}", idx, crmSequeseGenerator.getClass().getName());
      } catch (Exception e) {
        log.warn("{}、算法初始化-失败:{}", idx, crmSequeseGenerator.getClass().getName());
      }
    }
  }

}
