package com.biz.crm.common.sequese.local.service.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.sequese.local.config.CommonSequeseConfig;
import com.biz.crm.common.sequese.local.service.SerialNumberService;
import com.biz.crm.common.sequese.sdk.dto.SerialNumberDto;
import com.biz.crm.common.sequese.sdk.generator.constant.SequeseConstant;
import com.biz.crm.common.sequese.sdk.generator.service.CrmSequeseFactoryService;
import com.biz.crm.common.sequese.sdk.generator.service.base.BaseCrmBizSequenceService;
import com.biz.crm.common.sequese.sdk.generator.service.base.CrmBizSequenceServiceByStrategy;
import com.biz.crm.common.sequese.sdk.vo.SerialNumberVo;
import cn.hutool.core.text.CharSequenceUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * @author XXLsansui
 * @date 2023-04-26 20:17
 * @description：
 */
@Service
@Slf4j
public class SerialNumberServiceImpl implements SerialNumberService {

  @Autowired(required = false)
  private RedisTemplate<String, String> redisTemplate;
  @Autowired(required = false)
  private CrmSequeseFactoryService crmSequeseFactoryService;



  /**
   * 分页查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  @Override
  public Page<SerialNumberVo> findByConditions(Pageable pageable, SerialNumberDto dto) {

    List<CrmBizSequenceServiceByStrategy> crmBizSequenceServiceList = crmSequeseFactoryService.getCrmBizSequenceServiceList();
    crmBizSequenceServiceList = ObjectUtils.isEmpty(crmBizSequenceServiceList) ? new ArrayList<>() : crmBizSequenceServiceList;
    List<SerialNumberVo> serialNumberVos = new ArrayList<>();
    for(BaseCrmBizSequenceService item : crmBizSequenceServiceList){
      SerialNumberVo one = new SerialNumberVo();
      String seqInfoByBizCode = item.getSeqInfoByBizCode();
      //业务编码
      one.setSerialBusinessCode(seqInfoByBizCode);
      //模块名称
      one.setModuleName(item.getSeqInfoByModleName());
      // 序列号的取值
      String saveKey = CharSequenceUtil.format("{}:{}", CommonSequeseConfig.subsystem, seqInfoByBizCode);
      String cacheKey = CharSequenceUtil.format(SequeseConstant.SEQ_CACHE_VAL, saveKey);
      String nextVal = redisTemplate.opsForValue().get(cacheKey);
      log.info("获取的key:{}, val:{}", cacheKey, nextVal);
      one.setSerialCode(nextVal);
      // 编码规则
      one.setRuleCode(item.getGenerator().getSequeseRuleCode());

      serialNumberVos.add(one);
    }
    //筛选条件
    serialNumberVos = serialNumberVos.stream().filter(k ->
            k.getSerialBusinessCode().contains(StringUtils.isNotEmpty(dto.getSerialBusinessCode()) ? dto.getSerialBusinessCode() : "")
            && k.getModuleName().contains(StringUtils.isNotEmpty(dto.getModuleName()) ? dto.getModuleName() : "")
            && k.getRuleCode().contains(StringUtils.isNotEmpty(dto.getRuleCode()) ? dto.getRuleCode() : "")
    ).collect(Collectors.toList());

    //存放位置 内存
    int total = serialNumberVos.size();
    Page<SerialNumberVo> result = new Page<>(pageable.getPageNumber(), pageable.getPageSize(), total);
    int startIndex = (pageable.getPageNumber()-1) * pageable.getPageSize();
    int endIndex = Math.min(startIndex+pageable.getPageSize(),total);
    result.setRecords(serialNumberVos.subList(startIndex,endIndex));
    return result;
  }

  /**
   * 针对模块添加刷新标识
   *
   * @param dto
   */
  @Override
  public void addUpdateFlag(SerialNumberDto dto) {
    // 判断是否存放单个还是全部的lock 标识 isAll: true/false
    String key = "";
    String subSystem = CommonSequeseConfig.subsystem;
    if(dto.getIsAllLock()){
      //刷新全部key
      key = CharSequenceUtil.format(SequeseConstant.SEQ_CACHE_SAVE_ALL, subSystem);
    }else {
      Validate.isTrue(StringUtils.isNotEmpty(dto.getSerialBusinessCode()), "请选择单个刷新的序列号");
      String cacheKey = CharSequenceUtil.format("{}:{}", CommonSequeseConfig.subsystem, dto.getSerialBusinessCode());
      key = CharSequenceUtil.format(SequeseConstant.SEQ_CACHE_SAVE, cacheKey);
    }
    //存放有效期5分钟的key
    redisTemplate.opsForValue().set(key, "", 5, TimeUnit.MINUTES);
  }
}
