/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sequese.local.algorithm.snowflake.service;

import cn.hutool.core.lang.generator.SnowflakeGenerator;
import com.biz.crm.common.sequese.sdk.generator.service.aigorithm.CrmSequeseGeneratorBySnowFlake;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CrmSequeseGeneratorBySnowFlakeImpl
implements CrmSequeseGeneratorBySnowFlake {
    private static final Logger log = LoggerFactory.getLogger(CrmSequeseGeneratorBySnowFlakeImpl.class);
    private Map<String, SnowflakeGenerator> generatorMap = new HashMap<String, SnowflakeGenerator>(16);
    @Autowired
    private RedisMutexService redisMutexService;
    private static final Map<String, Integer> dataCenterMap = new HashMap<String, Integer>(10);
    public static final String DEFAULT_DATA_CENTER = "default";
    private static volatile SnowflakeGenerator generator;

    public Long currVal(String subSystem, String bizCode) {
        log.warn("\u5f53\u524d\u7b97\u6cd5\u4e0d\u652f\u6301");
        return null;
    }

    public String getSequeseRuleCode() {
        return "\u96ea\u82b1\u7b97\u6cd5";
    }

    public Long nextVal(String subSystem, String bizCode) {
        SnowflakeGenerator generator = this.getGeneratorCache(subSystem, bizCode);
        return generator.next();
    }

    public Long[] nextValArray(String subSystem, String bizCode, int seqNum) {
        if (seqNum < 1) {
            seqNum = 1;
        }
        SnowflakeGenerator generator = this.getGeneratorCache(subSystem, bizCode);
        Long[] batchNextVal = new Long[seqNum];
        for (int idx = 0; idx < batchNextVal.length; ++idx) {
            batchNextVal[idx] = generator.next();
        }
        return batchNextVal;
    }

    public void initAlgorithm() {
        dataCenterMap.put(DEFAULT_DATA_CENTER, 0);
        dataCenterMap.put("crm-mdm", 1);
        dataCenterMap.put("crm-dms", 2);
        dataCenterMap.put("crm-sfa", 3);
        dataCenterMap.put("crm-ems", 4);
        dataCenterMap.put("crm-kms", 5);
        dataCenterMap.put("crm-tpm", 6);
        dataCenterMap.put("crm-octm", 7);
        dataCenterMap.put("workflow", 8);
    }

    private int getDataCenterId(String key) {
        Integer dataCenterId = dataCenterMap.get(key);
        if (dataCenterId == null) {
            log.warn("{}\u672a\u5728\u7cfb\u7edf\u6ce8\u518c\uff0c\u4f7f\u7528\u9ed8\u8ba40\u6570\u636e\u4e2d\u5fc3", (Object)key);
            dataCenterId = dataCenterMap.get(DEFAULT_DATA_CENTER);
        }
        return dataCenterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SnowflakeGenerator getSnowflakeGenerator(String key) {
        long dataCenterId = this.getDataCenterId(key);
        long workerId = this.getWorkerId(key);
        if (!ObjectUtils.isEmpty((Object)generator)) return generator;
        Class<SnowflakeGenerator> clazz = SnowflakeGenerator.class;
        synchronized (SnowflakeGenerator.class) {
            if (!ObjectUtils.isEmpty((Object)generator)) return generator;
            generator = new SnowflakeGenerator(workerId, dataCenterId);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            return generator;
        }
    }

    public String getKey(String subSystem, String bizCode) {
        return String.format("%s", subSystem.toUpperCase());
    }

    private SnowflakeGenerator getGeneratorCache(String subSystem, String bizCode) {
        String key = this.getKey(subSystem, null);
        SnowflakeGenerator generator = this.generatorMap.get(key);
        if (generator == null) {
            generator = this.getSnowflakeGenerator(key);
            this.generatorMap.put(key, generator);
        }
        return generator;
    }

    private long getWorkerId(String subSystem) {
        for (int i = 0; i < 10000; ++i) {
            log.info("SnowFlake\u7a7a\u8282\u70b9: {}", (Object)i);
            i = Math.floorMod(i, 32);
            String key = String.format("crm_sequese:snowflake:%s:%02d", subSystem, i);
            try {
                if (!this.redisMutexService.tryLock(key, TimeUnit.SECONDS, 10)) continue;
                log.info("SnowFlake \u5f53\u524d\u8282\u70b9\u6570:{}, \u83b7\u53d6\u673a\u5668\u8282\u70b9key: {}", (Object)i, (Object)key);
                return i;
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return 0L;
    }
}

