/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sequese.local.generator;

import cn.hutool.cache.impl.TimedCache;
import cn.hutool.core.text.CharSequenceUtil;
import com.biz.crm.common.sequese.local.config.CommonSequeseConfig;
import com.biz.crm.common.sequese.sdk.generator.service.CrmSequeseFactoryService;
import com.biz.crm.common.sequese.sdk.generator.service.base.CrmBizSequenceServiceByNoParam;
import com.biz.crm.common.sequese.sdk.generator.service.base.CrmBizSequenceServiceByStrategy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class CrmSequeseFactoryServiceImpl
implements CrmSequeseFactoryService {
    private static final Logger log = LoggerFactory.getLogger(CrmSequeseFactoryServiceImpl.class);
    private static final Lock SEQ_SERV_MAP_LOCK = new ReentrantLock(true);
    private static Map<String, CrmBizSequenceServiceByStrategy> crmBizSequenceServiceMap;
    private List<CrmBizSequenceServiceByStrategy> crmBizSequenceServiceList;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private CrmBizSequenceServiceByNoParam crmBizSequenceServiceByNoParam;

    @Autowired(required=false)
    public void setCrmBizSequenceServiceList(List<CrmBizSequenceServiceByStrategy> list) {
        this.crmBizSequenceServiceList = list;
        crmBizSequenceServiceMap = new HashMap<String, CrmBizSequenceServiceByStrategy>(list.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CrmBizSequenceServiceByStrategy getCrmBizSequenceService(T dto) {
        if (dto == null) {
            return null;
        }
        String seqServMapKey = dto.getClass().getName();
        CrmBizSequenceServiceByStrategy seqServ = null;
        Map<String, CrmBizSequenceServiceByStrategy> map = crmBizSequenceServiceMap;
        seqServ = map.get(seqServMapKey);
        if (seqServ != null) {
            return seqServ;
        }
        SEQ_SERV_MAP_LOCK.lock();
        try {
            seqServ = map.get(seqServMapKey);
            if (seqServ != null) {
                CrmBizSequenceServiceByStrategy crmBizSequenceServiceByStrategy = seqServ;
                return crmBizSequenceServiceByStrategy;
            }
            for (CrmBizSequenceServiceByStrategy oneSeqServ : this.crmBizSequenceServiceList) {
                boolean match = oneSeqServ.match(dto);
                if (!match) continue;
                seqServ = oneSeqServ;
                map.put(seqServMapKey, oneSeqServ);
                break;
            }
        }
        finally {
            SEQ_SERV_MAP_LOCK.unlock();
        }
        return seqServ;
    }

    public <T> String nextVal(T dto) throws ClassCastException {
        CrmBizSequenceServiceByStrategy seqServ = this.getCrmBizSequenceService(dto);
        if (seqServ == null) {
            return this.nextVal();
        }
        String nextVal = seqServ.nextVal(dto);
        this.autoSaveRedis(seqServ.getSeqInfoByBizCode(), nextVal);
        return nextVal;
    }

    public <T> String[] nextVal(T dto, int seqNum) throws ClassCastException {
        CrmBizSequenceServiceByStrategy seqServ = this.getCrmBizSequenceService(dto);
        if (seqServ == null) {
            return this.nextValArray(seqNum);
        }
        String[] nextValArray = seqServ.nextVal(dto, seqNum);
        this.autoSaveRedis(seqServ.getSeqInfoByBizCode(), nextValArray[nextValArray.length - 1]);
        return nextValArray;
    }

    public <T> String nextVal() throws ClassCastException {
        return this.crmBizSequenceServiceByNoParam.nextVal();
    }

    public <T> String[] nextValArray(int seqNum) throws ClassCastException {
        return this.crmBizSequenceServiceByNoParam.nextValArray(seqNum);
    }

    public <T> String currVal(T dto) {
        CrmBizSequenceServiceByStrategy seqServ = this.getCrmBizSequenceService(dto);
        if (seqServ == null) {
            return null;
        }
        String cacheKey = CharSequenceUtil.format((CharSequence)"{}:{}", (Object[])new Object[]{CommonSequeseConfig.subsystem, seqServ.getSeqInfoByBizCode()});
        String key = CharSequenceUtil.format((CharSequence)"seq:{}:val", (Object[])new Object[]{cacheKey});
        String currVal = (String)this.redisTemplate.opsForValue().get((Object)key);
        return currVal;
    }

    public <T> boolean redo(T dto, String ... sequenceValue) {
        CrmBizSequenceServiceByStrategy seqServ = this.getCrmBizSequenceService(dto);
        if (seqServ == null) {
            return false;
        }
        return seqServ.redo(sequenceValue);
    }

    private void autoSaveRedis(String seqInfoByBizCode, String nextVal) {
        String cacheKey = CharSequenceUtil.format((CharSequence)"{}:{}", (Object[])new Object[]{CommonSequeseConfig.subsystem, seqInfoByBizCode});
        this.saveRedis(cacheKey, "" + nextVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsKey(String cacheKey) {
        Boolean exists = (Boolean)CommonSequeseConfig.lastLoadRedisCache.get((Object)cacheKey);
        if (exists == null) {
            TimedCache<String, Boolean> timedCache = CommonSequeseConfig.lastLoadRedisCache;
            synchronized (timedCache) {
                exists = (Boolean)CommonSequeseConfig.lastLoadRedisCache.get((Object)cacheKey);
                if (exists == null) {
                    String saveKey = CharSequenceUtil.format((CharSequence)"seq:{}:_SAVE", (Object[])new Object[]{cacheKey});
                    exists = this.exists(saveKey) || this.exists(CommonSequeseConfig.SAVE_ALL_KEY);
                    CommonSequeseConfig.lastLoadRedisCache.put((Object)cacheKey, (Object)exists);
                    log.debug("\u83b7\u53d6\u4e00\u6b21Redis");
                    System.out.println("\u83b7\u53d6\u4e00\u6b21Redis");
                }
            }
        }
        return exists;
    }

    private boolean exists(String key) {
        Boolean hasKey = this.redisTemplate.hasKey((Object)key);
        return hasKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRedis(String cacheKey, String nextVal) {
        Boolean isSave = (Boolean)CommonSequeseConfig.saveLashSeqCache.get((Object)cacheKey);
        if (isSave == null) {
            TimedCache<String, Boolean> timedCache = CommonSequeseConfig.saveLashSeqCache;
            synchronized (timedCache) {
                isSave = (Boolean)CommonSequeseConfig.saveLashSeqCache.get((Object)cacheKey);
                if (isSave == null) {
                    String key = CharSequenceUtil.format((CharSequence)"seq:{}:val", (Object[])new Object[]{cacheKey});
                    this.redisTemplate.opsForValue().set((Object)key, (Object)nextVal);
                    CommonSequeseConfig.saveLashSeqCache.put((Object)cacheKey, (Object)Boolean.TRUE);
                    log.debug("\u4fdd\u5b58Redis");
                }
            }
        }
    }

    public List<CrmBizSequenceServiceByStrategy> getCrmBizSequenceServiceList() {
        return this.crmBizSequenceServiceList;
    }
}

