/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.sequese.local.service.internal;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.sequese.local.config.CommonSequeseConfig;
import com.biz.crm.common.sequese.local.service.SerialNumberService;
import com.biz.crm.common.sequese.sdk.dto.SerialNumberDto;
import com.biz.crm.common.sequese.sdk.generator.service.CrmSequeseFactoryService;
import com.biz.crm.common.sequese.sdk.generator.service.base.BaseCrmBizSequenceService;
import com.biz.crm.common.sequese.sdk.vo.SerialNumberVo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class SerialNumberServiceImpl
implements SerialNumberService {
    private static final Logger log = LoggerFactory.getLogger(SerialNumberServiceImpl.class);
    @Autowired(required=false)
    private RedisTemplate<String, String> redisTemplate;
    @Autowired(required=false)
    private CrmSequeseFactoryService crmSequeseFactoryService;

    @Override
    public Page<SerialNumberVo> findByConditions(Pageable pageable, SerialNumberDto dto) {
        List crmBizSequenceServiceList = this.crmSequeseFactoryService.getCrmBizSequenceServiceList();
        crmBizSequenceServiceList = ObjectUtils.isEmpty((Object)crmBizSequenceServiceList) ? new ArrayList() : crmBizSequenceServiceList;
        List<Object> serialNumberVos = new ArrayList();
        for (BaseCrmBizSequenceService item : crmBizSequenceServiceList) {
            SerialNumberVo one = new SerialNumberVo();
            String seqInfoByBizCode = item.getSeqInfoByBizCode();
            one.setSerialBusinessCode(seqInfoByBizCode);
            one.setModuleName(item.getSeqInfoByModleName());
            String saveKey = CharSequenceUtil.format((CharSequence)"{}:{}", (Object[])new Object[]{CommonSequeseConfig.subsystem, seqInfoByBizCode});
            String cacheKey = CharSequenceUtil.format((CharSequence)"seq:{}:val", (Object[])new Object[]{saveKey});
            String nextVal = (String)this.redisTemplate.opsForValue().get((Object)cacheKey);
            log.info("\u83b7\u53d6\u7684key:{}, val:{}", (Object)cacheKey, (Object)nextVal);
            one.setSerialCode(nextVal);
            one.setRuleCode(item.getGenerator().getSequeseRuleCode());
            serialNumberVos.add(one);
        }
        serialNumberVos = serialNumberVos.stream().filter(k -> k.getSerialBusinessCode().contains(StringUtils.isNotEmpty((CharSequence)dto.getSerialBusinessCode()) ? dto.getSerialBusinessCode() : "") && k.getModuleName().contains(StringUtils.isNotEmpty((CharSequence)dto.getModuleName()) ? dto.getModuleName() : "") && k.getRuleCode().contains(StringUtils.isNotEmpty((CharSequence)dto.getRuleCode()) ? dto.getRuleCode() : "")).collect(Collectors.toList());
        int total = serialNumberVos.size();
        Page result = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize(), (long)total);
        int startIndex = (pageable.getPageNumber() - 1) * pageable.getPageSize();
        int endIndex = Math.min(startIndex + pageable.getPageSize(), total);
        result.setRecords(serialNumberVos.subList(startIndex, endIndex));
        return result;
    }

    @Override
    public void addUpdateFlag(SerialNumberDto dto) {
        String key = "";
        String subSystem = CommonSequeseConfig.subsystem;
        if (dto.getIsAllLock().booleanValue()) {
            key = CharSequenceUtil.format((CharSequence)"seq:{}:_SAVE_ALL", (Object[])new Object[]{subSystem});
        } else {
            Validate.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dto.getSerialBusinessCode()), (String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u5237\u65b0\u7684\u5e8f\u5217\u53f7", (Object[])new Object[0]);
            String cacheKey = CharSequenceUtil.format((CharSequence)"{}:{}", (Object[])new Object[]{CommonSequeseConfig.subsystem, dto.getSerialBusinessCode()});
            key = CharSequenceUtil.format((CharSequence)"seq:{}:_SAVE", (Object[])new Object[]{cacheKey});
        }
        this.redisTemplate.opsForValue().set((Object)key, (Object)"", 5L, TimeUnit.MINUTES);
    }
}

