package com.biz.crm.common.sequese.sdk.generator.service.base;

import com.biz.crm.common.sequese.sdk.generator.service.CrmBizSequenceServiceByInteger;
import com.biz.crm.common.sequese.sdk.generator.service.CrmBizSequenceServiceByString;
import com.biz.crm.common.sequese.sdk.generator.service.CrmSequeseGenerator;

/**
 * 扩展点1：默认算法，不需要传入参数，默认类型
 * 
 * @author Ken.xu
 * @version 1.0 Copyright 2023年4月21日 下午6:49:49
 * @param <K> Dto对象类型
 * @param <T> CrmSequeseGenerator 实现类
 * @param <V> 序列
 * @see CrmBizSequenceServiceByInteger
 * @see CrmBizSequenceServiceByString
 */
public interface CrmBizSequenceServiceByNoParam<T extends CrmSequeseGenerator<Long>>
    extends BaseCrmBizSequenceService<T, Long> {
  @Override
  default Long getSequese(String subSystem, String bizCode) {
    return BaseCrmBizSequenceService.super.getSequese(subSystem, bizCode);
  }

  @Override
  default Long[] getSequeseArray(String subsystem, String bizCode, int seqNum) {
    return BaseCrmBizSequenceService.super.getSequeseArray(subsystem, bizCode, seqNum);
  }

  /**
   * 扩展点：对序列值进行格式化
   * 
   * @param dto
   * @return
   */
  public String generatorFormat(final Long sequese);

  /**
   * 获取下一个值
   * 
   * @return
   */
  default String nextVal() {
    Long sequese = this.getSequese(this.getSubSystem(), this.getSeqInfoByBizCode());
    String nextVal = generatorFormat(sequese);
    return nextVal;
  }

  /**
   * 获取下一组序列号
   * 
   * @param seqNum 获取多少个
   * @return
   */
  default String[] nextValArray(final int seqNum) {
    String[] destArray = new String[seqNum];
    // 获取一部分新数据，进行填充后续数组字段
    Long[] seqArray = this.getSequeseArray(this.getSubSystem(), this.getSeqInfoByBizCode(), seqNum);
    for (int idx = seqArray.length - 1; idx >= 0; idx--) {
      Long sequese = seqArray[idx];
      String nextVal = generatorFormat(sequese);
      destArray[idx] = nextVal;
    }
    return destArray;
  }


}
