package com.biz.crm.common.sequese.sdk.generator.service;

import java.util.List;
import com.biz.crm.common.sequese.sdk.generator.service.base.BaseCrmBizSequenceService;
import com.biz.crm.common.sequese.sdk.generator.service.base.CrmBizSequenceServiceByStrategy;

/**
 * 序列工厂服务<br/>
 * 需要各项目组自行实现自己的<b>SeqName</b>对象
 * 
 * @author Ken.xu
 * @see SeqName#getSeqName() SeqName.getSeqName()用于告知具体业务算法实现类的组件名称
 *
 */
public interface CrmSequeseFactoryService {
  /** 提供给前端展示使用 */
  List<CrmBizSequenceServiceByStrategy> getCrmBizSequenceServiceList();

  /** 根据传入对象，使用策略模式，返回序列号生成器 */
  <T> BaseCrmBizSequenceService getCrmBizSequenceService(T dtoClass);

  /**
   * 1、服务首先通过"ORDER_SEQ_01"这个名字，遍历本地所有序列生成器：是否有这个名字，如果有这个名字，则继续，否则弹出运行异常。
   * 2、根据查到的生成器，调用该生成器内部的算法接口getSeq(vo)获取全系统唯一的值。
   * 
   * @param <T> 传入的dto对象类型
   * @param dto 传入给业务编码执行使用的业务对象
   * @return 序列号
   * @throws ClassCastException 如果类型转换错误，会返回该异常
   */
  <T> String nextVal(T dto) throws ClassCastException;

  /**
   * 1、服务首先通过"ORDER_SEQ_01"这个名字，遍历本地所有序列生成器：是否有这个名字，如果有这个名字，则继续，否则弹出运行异常。
   * 2、根据查到的生成器，调用该生成器内部的算法接口getSeq(vo)获取全系统唯一的一组值。
   * 
   * @param <T> 传入的dto对象类型
   * @param dto 传入给业务编码执行使用的业务对象
   * @param seqNum 批量获取多少个序列
   * @return 一组序列号
   * @throws ClassCastException 如果类型转换错误，会返回该异常
   */
  <T> String[] nextVal(T dto, int seqNum) throws ClassCastException;

  /**
   * 1、默认使用雪花算法返回下一个值
   * 
   * @param <T> 传入的dto对象类型
   * @param seqServiceName 业务编码【业务执行器的Spring组件名称】
   * @param dto 传入给业务编码执行使用的业务对象
   * @return 序列号
   * @throws ClassCastException 如果类型转换错误，会返回该异常
   */
  <T> String nextVal() throws ClassCastException;

  /**
   * 下一组变量值
   * 
   * @param <T>
   * @param seqNum
   * @return
   * @throws ClassCastException
   */
  <T> String[] nextValArray(int seqNum) throws ClassCastException;

  /**
   * 获取缓存到Redis中最后一个值
   * 
   * @param seqServiceName
   * @return
   */
  <T> String currVal(T dtoClass);

  /**
   * 将序列号返回给生成器，如果对应的序列生成器支持redo，则返回true，否则返回false
   * 
   * @param dto 用于标记当前序列生成器
   * @param sequenceValue
   * @return
   */
  <T> boolean redo(T dtoClass, String... sequenceValue);
}
