package com.biz.crm.common.sequese.sdk.generator.service.base;

import com.biz.crm.common.sequese.sdk.generator.service.CrmSequeseGenerator;

public interface BaseCrmBizSequenceService<T extends CrmSequeseGenerator<V>, V> {

  /**
   * 扩展点：获取当前使用的算法
   * 
   * @see CrmSequeseGenerator CrmSequeseGenerator的子类进行实现
   */
  T getGenerator();

  /** 扩展点：获取当前类的日志对象 */
  org.slf4j.Logger getLogger();

  /**
   * 扩展点： 获取当天工作子节点，<br/>
   * 例如 @Value("${spring.application.name:}")
   */
  String getSubSystem();

  /** 序列信息：获取序列名称,用于判断是否是当前策略 */
  String getSeqInfoByBizCode();

  /** 序列信息：获取字段描述 */
  String getSeqInfoByColumnDesc();

  /** 序列信息：获取模块名称 */
  String getSeqInfoByModleName();

  /**
   * 获取序列值
   * 
   * @param subsystem 子系统
   * @param bizCode 业务编码
   * @return
   */
  default V getSequese(String subSystem, String bizCode) {
    CrmSequeseGenerator<V> crmSequeseGenerator = this.getGenerator();
    V code = crmSequeseGenerator.nextVal(subSystem, bizCode);
    return code;
  }

  /**
   * 获取一组序列值
   * 
   * @param subsystem 子系统
   * @param bizCode 业务编码
   * @param seqNum 获取多少个序列
   * @return 序列数组
   */
  default V[] getSequeseArray(String subsystem, String bizCode, int seqNum) {
    // 数据纠正
    if (seqNum < 1) {
      seqNum = 1;
    }
    CrmSequeseGenerator<V> crmSequeseGenerator = this.getGenerator();
    V[] nextValArray = crmSequeseGenerator.nextValArray(subsystem, bizCode, seqNum);
    return nextValArray;
  }
}
