package com.biz.crm.common.sequese.sdk.generator.service.base;

import com.biz.crm.common.sequese.sdk.generator.service.CrmSequeseGenerator;

/**
 * 扩展点1：编码规则接口【扩展点1，实现指定接口，用于返回指定（模块、业务编码）下的全局唯一的值】， 使用的类，必须扩展Component注解和Description注解
 * 
 * @author Ken.xu
 * @version 1.0 Copyright 2023年4月21日 下午6:49:49
 * @param <K> Dto对象类型
 * @param <T> CrmSequeseGenerator 实现类
 * @param <V> CrmSequeseGenerator 返回序列的类型
 */
public interface CrmBizSequenceServiceByStrategy<K, T extends CrmSequeseGenerator<V>, V>
    extends BaseCrmBizSequenceService<T, V> {
  /**
   * 策略模式：判断当前对象是否可以处理
   * 
   * @param obj Object对象，用于判断该对象是否可以被当前实现
   * @return
   */
  boolean match(Object obj);

  /**
   * 扩展点：对序列值进行格式化
   * 
   * @param dto
   * @return
   */
  String generatorFormat(K dto, final V sequese);

  /**
   * 获取nextVal，根据泛型获取<br/>
   * 
   * @param dto 泛型对象
   * @return 一个序列号
   */
  default String nextVal(K dto) {
    String[] redoArray = getRedoArray(1);
    if (redoArray != null) {
      return redoArray[0];
    }
    // 获取序列,以及必要的参数
    V sequese = this.getSequese(this.getSubSystem(), this.getSeqInfoByBizCode());
    String nextVal = generatorFormat(dto, sequese);
    return nextVal;
  }

  /**
   * 获取nextVal，根据泛型获取
   * 
   * @param dto 泛型对象
   * @param seqNum 连续获取多少个序列值
   * @return 一组序列号
   */
  default String[] nextVal(K dto, final int seqNum) {
    String[] destArray = null;
    int needSeqNum = seqNum, redoLength = 0;

    final String[] redoArray = getRedoArray(needSeqNum);
    if (redoArray == null) {
      // 没有拿到数据，直接开始
      destArray = new String[seqNum];
    } else {
      // 拿到缓存数据，将缓存数据先行填充，然后再获取新值
      redoLength = redoArray.length;
      needSeqNum -= redoLength;
      if (needSeqNum == 0) {
        return redoArray;
      }
      // redo里面的数据不足以填充，需要再获取一些
      destArray = new String[seqNum];
      // step1:获取数据
      System.arraycopy(redoArray, 0, destArray, 0, redoLength);
    }
    // 获取一部分新数据，进行填充后续数组字段
    V[] seqArray = this.getSequeseArray(this.getSubSystem(), this.getSeqInfoByBizCode(), needSeqNum);
    for (int idx = seqArray.length - 1; idx >= 0; idx--) {
      V sequese = seqArray[idx];
      String nextVal = generatorFormat(dto, sequese);
      destArray[redoLength + idx] = nextVal;
    }
    return destArray;
  }

  /**
   * 项目组自行实现释放支持redo，如果支持，则后续获取序列号，优先从redo的list中获取
   * 
   * @return
   * @see #getRedo(int)
   */
  default boolean redo(String... sequenceValue) {
    return false;
  }

  /**
   * 获取redo的序列，项目组，如果redo可行，这里就需要做redo数组的获取，注意，如果没有redo的数据必须返回null
   * 
   * @param seqNum
   * @return
   * @see #redo(String...)
   */
  default String[] getRedoArray(final int seqNum) {
    return null;
  }

}
