/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.errorlog.local.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RolloverFailure;
import com.biz.crm.common.errorlog.sdk.dto.ErrorInfo;
import com.biz.crm.common.errorlog.sdk.utils.EsUtils;
import java.util.Date;
import java.util.UUID;
import org.springframework.stereotype.Component;

@Component
public class EsDefinedAppender<E>
extends FileAppender<E> {
    private RollingPolicy rollingPolicy;
    private Encoder encoder;
    private String systemName;

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void setEncoder(Encoder encoder) {
        this.encoder = encoder;
    }

    public void setRollingPolicy(RollingPolicy rollingPolicy) {
        this.rollingPolicy = rollingPolicy;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    protected void append(Object eventObject) {
        ILoggingEvent e = (ILoggingEvent)eventObject;
        byte[] bytes = this.encoder.encode((Object)e);
        String msg = new String(bytes, "UTF-8");
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.setMsgId(UUID.randomUUID().toString().replace("-", ""));
        errorInfo.setMsg(msg);
        errorInfo.setType(this.systemName);
        errorInfo.setLevel("ERROR");
        Date date = new Date();
        errorInfo.setDate(date.getTime());
        EsUtils.addErrorMsg((ErrorInfo)errorInfo);
        this.attemptRollover();
    }

    private void attemptRollover() {
        try {
            this.rollingPolicy.rollover();
        }
        catch (RolloverFailure rf) {
            this.addWarn("RolloverFailure occurred. Deferring roll-over.");
            this.append = true;
        }
    }
}

