/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.errorlog.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.errorlog.local.service.ErrorLogService;
import com.biz.crm.common.errorlog.sdk.dto.ErrorInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/errorlog/errorlog"})
@Api(tags={"\u9519\u8bef\u65e5\u5fd7: NewsNotice: \u9519\u8bef\u65e5\u5fd7"})
public class ErrorLogController {
    private static final Logger log = LoggerFactory.getLogger(ErrorLogController.class);
    @Autowired
    private ErrorLogService errorLogService;

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8\u9519\u8bef\u4fe1\u606f")
    @GetMapping(value={"/findBySource"})
    public Result<List<ErrorInfo>> findBySource(@RequestParam(value="source") String source) {
        try {
            List<ErrorInfo> res = this.errorLogService.findBySource(source);
            return Result.ok(res);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5728\u7ebf\u7684CRM\u670d\u52a1")
    @GetMapping(value={"/findCRMSystem"})
    public Result<List<String>> findCRMSystem() {
        try {
            List<String> crmSystem = this.errorLogService.findCRMSystem();
            return Result.ok(crmSystem);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

