/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.errorlog.local.service.impl;

import com.biz.crm.common.errorlog.local.service.ErrorLogService;
import com.biz.crm.common.errorlog.sdk.dto.ErrorInfo;
import com.biz.crm.common.errorlog.sdk.utils.EsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ErrorLogServiceImpl
implements ErrorLogService {
    private static final Logger log = LoggerFactory.getLogger(ErrorLogServiceImpl.class);
    @Autowired
    private RedisTemplate redisTemplate;

    @Override
    public List<ErrorInfo> findBySource(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return new ArrayList<ErrorInfo>();
        }
        List search = EsUtils.search((String)source);
        if (CollectionUtils.isEmpty((Collection)search)) {
            return new ArrayList<ErrorInfo>();
        }
        return search.stream().sorted(Comparator.comparing(ErrorInfo::getDate).reversed()).collect(Collectors.toList());
    }

    @Override
    public List<String> findCRMSystem() {
        String key = "springboot-system-*";
        Set keys = this.redisTemplate.keys((Object)key);
        if (CollectionUtils.isEmpty((Collection)keys)) {
            return new ArrayList<String>();
        }
        List list = this.redisTemplate.opsForValue().multiGet((Collection)keys);
        return list;
    }
}

