package com.biz.crm.common.errorlog.sdk.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

import javax.persistence.Id;

/**
 * @author HanJiaJun
 * @describe: 错误信息实体
 * @createTime 2022年05月12日 11:21:00
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@Document(indexName = "log_error", replicas = 1, shards = 1, createIndex = true)
public class ErrorInfo {

  @Id
  @Field(index = true, store = true, type = FieldType.Keyword)//index:设置通过这个字段是否可以进行搜索
  private String msgId;

  /**
   * 日志来源
   */
  @Field(type = FieldType.Keyword)
  private String type;

  /**
   * 级别
   */
  @Field(type = FieldType.Keyword)
  private String level;
  /**
   * 信息
   */
  @Field(type = FieldType.Keyword)
  private String msg;

  /**
   * 产生时间
   */
  @Field(type = FieldType.Keyword)
  private long date;
}
