/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dynamicform/operation"})
public class OperationStrategyController {
    private static final Logger log = LoggerFactory.getLogger(OperationStrategyController.class);
    @Order
    @Autowired(required=false)
    private List<OperationStrategy<? extends DynamicForm>> operationStrateis;

    @ApiOperation(value="TODO \u5b8c\u5584\u6ce8\u91ca")
    @GetMapping(value={"findByDynamicFormCodeAndModuleCode"})
    public Result<?> findByDynamicFormCodeAndModuleCode(@RequestParam(value="dynamicFormCode") String dynamicFormCode, @RequestParam(value="moduleCode") String moduleCode) {
        try {
            JSONObject result = new JSONObject();
            for (OperationStrategy<? extends DynamicForm> operationStrategy : this.operationStrateis) {
                String dynamicFormCodeItem = operationStrategy.dynamicFormCode();
                String dynamicFormNameItem = operationStrategy.dynamicFormName();
                String moduleCodeItem = operationStrategy.moduleCode();
                if (!StringUtils.equals((CharSequence)dynamicFormCode, (CharSequence)dynamicFormCodeItem) || !StringUtils.equals((CharSequence)moduleCode, (CharSequence)moduleCodeItem)) continue;
                result.put("dynamicFormCode", (Object)dynamicFormCodeItem);
                result.put("dynamicFormName", (Object)dynamicFormNameItem);
                result.put("moduleCode", (Object)moduleCodeItem);
                break;
            }
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u7167\u4e1a\u52a1\u5206\u7ec4\uff0c\u67e5\u8be2\u8be5\u4e1a\u52a1\u5206\u7ec4\u4e0b\u5df2\u6ce8\u518c\u7684\u52a8\u6001\u8868\u5355\u64cd\u4f5c\u7b56\u7565\uff08\u5df2\u6d4b\u8bd5\uff09")
    @GetMapping(value={"findByModuleCode"})
    public Result<?> findByModuleCode(@RequestParam(value="moduleCode") String moduleCode) {
        try {
            JSONArray results = new JSONArray();
            for (OperationStrategy<? extends DynamicForm> operationStrategy : this.operationStrateis) {
                String dynamicFormCodeItem = operationStrategy.dynamicFormCode();
                String dynamicFormNameItem = operationStrategy.dynamicFormName();
                String moduleCodeItem = operationStrategy.moduleCode();
                if (!StringUtils.equals((CharSequence)moduleCode, (CharSequence)moduleCodeItem)) continue;
                JSONObject result = new JSONObject();
                result.put("dynamicFormCode", (Object)dynamicFormCodeItem);
                result.put("dynamicFormName", (Object)dynamicFormNameItem);
                result.put("moduleCode", (Object)moduleCodeItem);
                results.add((Object)result);
            }
            return Result.ok((Object)results);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

