/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.form.local.service.DynamicFormServiceOpStrategy;
import com.biz.crm.common.form.local.utils.DynamicFormUtils;
import com.biz.crm.common.form.sdk.DynamicFieldConfiguration;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.DynamicFormsOperationStrategy;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class DynamicFormServiceImpl<T>
implements DynamicFormService<T> {
    private Class<T> formClass;
    @Autowired
    private List<OperationStrategy<? extends DynamicForm>> operationStraties;
    @Autowired(required=false)
    private List<DynamicFormServiceOpStrategy> dynamicFormServiceOpStraties;
    private Map<String, DynamicFieldConfiguration<T>> dynamicFieldConfigurationMapping;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormServiceImpl.class);

    public DynamicFormServiceImpl(Class<T> formClass, Map<String, DynamicFieldConfiguration<T>> dynamicFieldConfigurationMapping) {
        this.formClass = formClass;
        this.dynamicFieldConfigurationMapping = Maps.newLinkedHashMap(dynamicFieldConfigurationMapping);
    }

    public T dynamic(JSONObject formJson) {
        if (formJson == null || CollectionUtils.isEmpty(this.dynamicFormServiceOpStraties)) {
            return null;
        }
        Object mainForm = JSON.parseObject((String)formJson.toJSONString(), this.formClass);
        Set<String> dynamicFieldCodes = this.dynamicFieldConfigurationMapping.keySet();
        for (String dynamicFieldCode : dynamicFieldCodes) {
            DynamicFieldConfiguration<T> dynamicFieldConfiguration;
            String[] dynamicKeys;
            Field dynamicField = this.findDynamicField(dynamicFieldCode);
            if (dynamicField == null || (dynamicKeys = (dynamicFieldConfiguration = this.dynamicFieldConfigurationMapping.get(dynamicFieldCode)).findDynamicKeys()) == null || dynamicKeys.length == 0) continue;
            Boolean isValueCollection = dynamicFieldConfiguration.isValueCollection();
            Class collectionClass = dynamicFieldConfiguration.getCollectionClass();
            JSONObject dynamicFieldValueMapping = formJson.getJSONObject(dynamicFieldCode);
            Validate.notNull((Object)dynamicFieldValueMapping, (String)"\u9519\u8bef\u7684\u52a8\u6001\u5b57\u6bb5\u6307\u5b9a\uff08\u53ef\u80fd\u5e76\u6ca1\u6709\u4f20\u5165\uff09\uff1a%s\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{dynamicFieldCode});
            DynamicFormServiceOpStrategy currentDynamicFormServiceOpStrategy = this.findDynamicFormServiceOpStrategy(this.dynamicFormServiceOpStraties, isValueCollection, collectionClass);
            if (currentDynamicFormServiceOpStrategy == null) {
                LOGGER.warn("\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u6570\u636e\u8f6c\u6362\u65f6\uff0c\u53d1\u73b0\u201c" + dynamicFieldCode + "\u201d\u7684\u7c7b\u578b\u548cjson\u7ed3\u6784\u7684\u503c\u4e0d\u80fd\u5bf9\u5e94\uff08json\u4e3a\u6570\u7ec4\uff09\uff0c\u8bf7\u68c0\u67e5!!");
                continue;
            }
            Map targetMapValues = currentDynamicFormServiceOpStrategy.createMapbeforeOp();
            for (String dynamicKey : dynamicKeys) {
                String dynamicFormCode;
                OperationStrategy<? extends DynamicForm> operationStrategy;
                Object mappingValue = null;
                mappingValue = isValueCollection == false ? dynamicFieldValueMapping.getJSONObject(dynamicKey) : dynamicFieldValueMapping.getJSONArray(dynamicKey);
                if (mappingValue == null || (operationStrategy = DynamicFormUtils.findByDynamicFormCode(dynamicFormCode = dynamicFieldConfiguration.findDynamicFormCodeByDynamicKey(dynamicKey), this.operationStraties)) == null) continue;
                Class targetDynamicFormClass = operationStrategy.dynamicFormClass();
                currentDynamicFormServiceOpStrategy.convert(targetMapValues, mainForm, dynamicField, dynamicKey, (JSON)mappingValue, targetDynamicFormClass, isValueCollection, collectionClass);
            }
            try {
                if (CollectionUtils.isEmpty(targetMapValues)) continue;
                dynamicField.set(mainForm, targetMapValues);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return (T)mainForm;
    }

    private DynamicFormServiceOpStrategy findDynamicFormServiceOpStrategy(List<DynamicFormServiceOpStrategy> dynamicFormServiceOpStraties, boolean isValueCollection, Class<?> collectionClass) {
        if (CollectionUtils.isEmpty(dynamicFormServiceOpStraties)) {
            return null;
        }
        List sortedDynamicFormServiceOpStraties = dynamicFormServiceOpStraties.stream().sorted((source, target) -> source.sort() - target.sort()).collect(Collectors.toList());
        DynamicFormServiceOpStrategy currentDynamicFormServiceOpStrategy = null;
        for (DynamicFormServiceOpStrategy dynamicFormServiceOpStrategy : sortedDynamicFormServiceOpStraties) {
            if (!dynamicFormServiceOpStrategy.support(isValueCollection, collectionClass)) continue;
            currentDynamicFormServiceOpStrategy = dynamicFormServiceOpStrategy;
        }
        return currentDynamicFormServiceOpStrategy;
    }

    private Field findDynamicField(String dynamicFieldCode) {
        Field dynamicField = null;
        try {
            dynamicField = this.formClass.getDeclaredField(dynamicFieldCode);
            dynamicField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOGGER.error("\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5b57\u6bb5\u4fe1\u606f: {}", (Object)dynamicFieldCode);
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return dynamicField;
    }

    @Transactional
    public void createDynamicDetails(T formObject, String parentCode) {
        this.saveDynamicDetails(formObject, parentCode, false);
    }

    private void saveDynamicDetails(T formObject, String parentCode, boolean isModify) {
        Validate.isTrue((this.formClass == formObject.getClass() ? 1 : 0) != 0, (String)"\u5f53\u524d\u6b63\u5728\u4fdd\u5b58\u7684\u4e3b\u4e1a\u52a1\u6570\u636e\u7c7b\u578b\u548c\u6307\u5b9a\u7684DynamicFormService\u6240\u670d\u52a1\u7684\u4e3b\u4e1a\u52a1\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull(formObject, (String)"\u5f53\u524d\u6b63\u5728\u4fdd\u5b58\u7684\u4e3b\u4e1a\u52a1\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)parentCode, (String)"\u5f53\u524d\u6b63\u5728\u4fdd\u5b58\u7684\u4e3b\u4e1a\u52a1\u6570\u636e\uff0c\u6ca1\u6709\u8bbe\u5b9a\u5176\u4e0e\u5404\u5b50\u7ea7\u52a8\u6001\u8868\u5355\u6570\u636e\u7684\u5173\u8054\u4fe1\u606f\u201cparentCode\u201d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<String> dynamicFieldCodes = this.dynamicFieldConfigurationMapping.keySet();
        if (CollectionUtils.isEmpty(dynamicFieldCodes)) {
            return;
        }
        for (String dynamicFieldCode : dynamicFieldCodes) {
            Map dynamicFieldValue;
            block8: {
                Field dynamicField = this.findDynamicField(dynamicFieldCode);
                if (dynamicField == null) continue;
                dynamicFieldValue = null;
                try {
                    dynamicFieldValue = (Map)dynamicField.get(formObject);
                    if (CollectionUtils.isEmpty((Map)dynamicFieldValue)) {
                    }
                    break block8;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                continue;
            }
            DynamicFieldConfiguration<T> dynamicFieldConfiguration = this.dynamicFieldConfigurationMapping.get(dynamicFieldCode);
            String[] dynamicKeys = dynamicFieldConfiguration.findDynamicKeys();
            if (dynamicKeys == null || dynamicKeys.length == 0) continue;
            Boolean isValueCollection = dynamicFieldConfiguration.isValueCollection();
            Class collectionClass = dynamicFieldConfiguration.getCollectionClass();
            DynamicFormServiceOpStrategy currentDynamicFormServiceOpStrategy = this.findDynamicFormServiceOpStrategy(this.dynamicFormServiceOpStraties, isValueCollection, collectionClass);
            if (currentDynamicFormServiceOpStrategy == null) {
                LOGGER.warn("\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u6570\u636e\u4fdd\u5b58\u65f6\uff0c\u53d1\u73b0\u201c" + dynamicFieldCode + "\u201d\u7684\u7c7b\u578b\u548cjson\u7ed3\u6784\u7684\u503c\u4e0d\u80fd\u5bf9\u5e94\uff08json\u4e3a\u6570\u7ec4\uff09\uff0c\u8bf7\u68c0\u67e5!!");
                continue;
            }
            for (String dynamicKey : dynamicKeys) {
                String dynamicFormCode = dynamicFieldConfiguration.findDynamicFormCodeByDynamicKey(dynamicKey);
                OperationStrategy<? extends DynamicForm> operationStrategy = DynamicFormUtils.findByDynamicFormCode(dynamicFormCode, this.operationStraties);
                if (operationStrategy == null) continue;
                Object dynamicKeyObject = dynamicFieldValue.get(dynamicKey);
                if (!isModify) {
                    if (dynamicKeyObject == null) continue;
                    currentDynamicFormServiceOpStrategy.createOp(operationStrategy, dynamicKey, dynamicKeyObject, formObject, parentCode);
                    continue;
                }
                currentDynamicFormServiceOpStrategy.modifyOp(operationStrategy, dynamicKey, dynamicKeyObject, formObject, parentCode);
            }
        }
    }

    @Transactional
    public void modifyDynamicDetails(T formObject, String parentCode) {
        this.saveDynamicDetails(formObject, parentCode, true);
    }

    @Transactional
    public void deleteDynamicDetails(String parentCode) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u5168\u9762\u5220\u9664\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u4e3b\u4e1a\u52a1\u5173\u8054\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<String> dynamicFieldCodes = this.dynamicFieldConfigurationMapping.keySet();
        if (CollectionUtils.isEmpty(dynamicFieldCodes)) {
            return;
        }
        for (String dynamicFieldCode : dynamicFieldCodes) {
            DynamicFieldConfiguration<T> dynamicFieldConfiguration;
            String[] dynamicKeys;
            Field dynamicField = this.findDynamicField(dynamicFieldCode);
            if (dynamicField == null || (dynamicKeys = (dynamicFieldConfiguration = this.dynamicFieldConfigurationMapping.get(dynamicFieldCode)).findDynamicKeys()) == null || dynamicKeys.length == 0) continue;
            for (String dynamicKey : dynamicKeys) {
                String dynamicFormCode = dynamicFieldConfiguration.findDynamicFormCodeByDynamicKey(dynamicKey);
                OperationStrategy<? extends DynamicForm> operationStrategy = DynamicFormUtils.findByDynamicFormCode(dynamicFormCode, this.operationStraties);
                if (operationStrategy == null) continue;
                operationStrategy.onDynamicFormsDelete(parentCode, dynamicKey);
            }
        }
    }

    @Transactional
    public void deleteDynamicDetails(String parentCode, String dynamicFieldCode, String dynamicKey, String[] detailCodes) {
        Validate.notBlank((CharSequence)parentCode, (String)"\u90e8\u5206\u5220\u9664\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u4e3b\u4e1a\u52a1\u5173\u8054\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicFieldCode, (String)"\u90e8\u5206\u5220\u9664\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u4e3b\u4e1a\u52a1\u5c5e\u6027/\u5b57\u6bb5\u540d\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicKey, (String)"\u90e8\u5206\u5220\u9664\u65f6\uff0c\u53d1\u73b0\u9519\u8bef\u7684\u4e3b\u4e1a\u52a1\u5c5e\u6027/\u5b57\u6bb5\u540d\u4fe1\u606f\u4e0b\u7684\u4e1a\u52a1\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((detailCodes != null && detailCodes.length > 0 ? 1 : 0) != 0, (String)"\u90e8\u5206\u5220\u9664\u65f6\uff0c\u81f3\u5c11\u9700\u8981\u6307\u5b9a\u4e00\u6761\u9700\u8981\u5220\u9664\u7684\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<String> dynamicFieldCodes = this.dynamicFieldConfigurationMapping.keySet();
        if (CollectionUtils.isEmpty(dynamicFieldCodes)) {
            return;
        }
        for (String dynamicFieldItem : dynamicFieldCodes) {
            DynamicFieldConfiguration<T> dynamicFieldConfiguration;
            String[] dynamicKeys;
            if (!StringUtils.equals((CharSequence)dynamicFieldCode, (CharSequence)dynamicFieldItem) || (dynamicKeys = (dynamicFieldConfiguration = this.dynamicFieldConfigurationMapping.get(dynamicFieldCode)).findDynamicKeys()) == null || dynamicKeys.length == 0) continue;
            for (String dynamicKeyItem : dynamicKeys) {
                if (!StringUtils.equals((CharSequence)dynamicKey, (CharSequence)dynamicKeyItem)) continue;
                String dynamicFormCode = dynamicFieldConfiguration.findDynamicFormCodeByDynamicKey(dynamicKey);
                Boolean isValueCollection = dynamicFieldConfiguration.isValueCollection();
                OperationStrategy<? extends DynamicForm> operationStrategy = DynamicFormUtils.findByDynamicFormCode(dynamicFormCode, this.operationStraties);
                if (operationStrategy == null || !isValueCollection.booleanValue()) continue;
                DynamicFormsOperationStrategy dynamicFormsOperationStrategy = (DynamicFormsOperationStrategy)operationStrategy;
                dynamicFormsOperationStrategy.onDynamicFormsDelete(parentCode, dynamicKey, detailCodes);
            }
        }
    }

    public void perfectDynamicDetails(T formObject, String parentCode) {
        if (formObject == null || StringUtils.isBlank((CharSequence)parentCode)) {
            return;
        }
        Set<String> dynamicFieldCodes = this.dynamicFieldConfigurationMapping.keySet();
        if (CollectionUtils.isEmpty(dynamicFieldCodes)) {
            return;
        }
        for (String dynamicFieldCode : dynamicFieldCodes) {
            Field dynamicField = this.findDynamicField(dynamicFieldCode);
            if (dynamicField == null) continue;
            dynamicField.setAccessible(true);
            DynamicFieldConfiguration<T> dynamicFieldConfiguration = this.dynamicFieldConfigurationMapping.get(dynamicFieldCode);
            String[] dynamicKeys = dynamicFieldConfiguration.findDynamicKeys();
            if (dynamicKeys == null || dynamicKeys.length == 0) continue;
            Boolean isValueCollection = dynamicFieldConfiguration.isValueCollection();
            Class collectionClass = dynamicFieldConfiguration.getCollectionClass();
            DynamicFormServiceOpStrategy currentDynamicFormServiceOpStrategy = this.findDynamicFormServiceOpStrategy(this.dynamicFormServiceOpStraties, isValueCollection, collectionClass);
            if (currentDynamicFormServiceOpStrategy == null) {
                LOGGER.warn("\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u6570\u636e\u5b8c\u5584\u65f6\uff0c\u53d1\u73b0\u201c" + dynamicFieldCode + "\u201d\u7684\u7c7b\u578b\u548cjson\u7ed3\u6784\u7684\u503c\u4e0d\u80fd\u5bf9\u5e94\uff08json\u4e3a\u6570\u7ec4\uff09\uff0c\u8bf7\u68c0\u67e5!!");
                continue;
            }
            for (String dynamicKey : dynamicKeys) {
                String dynamicFormCode = dynamicFieldConfiguration.findDynamicFormCodeByDynamicKey(dynamicKey);
                OperationStrategy<? extends DynamicForm> operationStrategy = DynamicFormUtils.findByDynamicFormCode(dynamicFormCode, this.operationStraties);
                if (operationStrategy == null) continue;
                currentDynamicFormServiceOpStrategy.findAndMergeByParentCode(operationStrategy, dynamicKey, dynamicField, formObject, parentCode);
            }
        }
    }

    public <D> D findDetailByParentCodeAndDynamicFieldAndDynamicKey(String parentCode, String dynamicFieldCode, String dynamicKey, Class<D> dclass) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{parentCode, dynamicFieldCode, dynamicKey}) || dclass == null) {
            return null;
        }
        DynamicFieldConfiguration<T> dynamicFieldConfiguration = this.dynamicFieldConfigurationMapping.get(dynamicFieldCode);
        CharSequence[] dynamicKeys = dynamicFieldConfiguration.findDynamicKeys();
        if (dynamicKeys == null || dynamicKeys.length == 0) {
            return null;
        }
        Boolean isValueCollection = dynamicFieldConfiguration.isValueCollection();
        if (isValueCollection.booleanValue()) {
            LOGGER.warn("\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u6570\u636e\u67e5\u8be2\u65f6\uff0c\u53d1\u73b0\u201c" + dynamicFieldCode + "\u201d\u5b57\u6bb5\u7684\u7c7b\u578b\uff0c\u4e0d\u80fd\u4e3a\u96c6\u5408\uff0c\u8bf7\u68c0\u67e5!!");
            return null;
        }
        Class collectionClass = dynamicFieldConfiguration.getCollectionClass();
        DynamicFormServiceOpStrategy currentDynamicFormServiceOpStrategy = this.findDynamicFormServiceOpStrategy(this.dynamicFormServiceOpStraties, isValueCollection, collectionClass);
        if (currentDynamicFormServiceOpStrategy == null) {
            LOGGER.warn("\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u6570\u636e\u67e5\u8be2\u65f6\uff0c\u53d1\u73b0\u201c" + dynamicFieldCode + "\u201d\u7684\u7c7b\u578b\u548cjson\u7ed3\u6784\u7684\u503c\u4e0d\u80fd\u5bf9\u5e94\uff08json\u4e3a\u6570\u7ec4\uff09\uff0c\u8bf7\u68c0\u67e5!!");
            return null;
        }
        if (StringUtils.indexOfAny((CharSequence)dynamicKey, (CharSequence[])dynamicKeys) == -1) {
            return null;
        }
        String dynamicFormCode = dynamicFieldConfiguration.findDynamicFormCodeByDynamicKey(dynamicKey);
        OperationStrategy<? extends DynamicForm> operationStrategy = DynamicFormUtils.findByDynamicFormCode(dynamicFormCode, this.operationStraties);
        if (operationStrategy == null) {
            return null;
        }
        Validate.isTrue((boolean)dclass.isAssignableFrom(operationStrategy.dynamicFormClass()), (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u6570\u636e\u67e5\u8be2\u65f6\uff0c\u53d1\u73b0\u8981\u6c42\u8fd4\u56de\u7684\u7c7b\u578b\u548c\u67e5\u8be2\u51fa\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Object result = currentDynamicFormServiceOpStrategy.findByParentCode(operationStrategy, dynamicKey, parentCode);
        return (D)result;
    }

    public <D> Collection<D> findDetailsByParentCodeAndDynamicFieldAndDynamicKey(String parentCode, String dynamicFieldCode, String dynamicKey, Class<D> dclass) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{parentCode, dynamicFieldCode, dynamicKey}) || dclass == null) {
            return null;
        }
        DynamicFieldConfiguration<T> dynamicFieldConfiguration = this.dynamicFieldConfigurationMapping.get(dynamicFieldCode);
        CharSequence[] dynamicKeys = dynamicFieldConfiguration.findDynamicKeys();
        if (dynamicKeys == null || dynamicKeys.length == 0) {
            return null;
        }
        Boolean isValueCollection = dynamicFieldConfiguration.isValueCollection();
        if (!isValueCollection.booleanValue()) {
            LOGGER.warn("\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u6570\u636e\u67e5\u8be2\u65f6\uff0c\u53d1\u73b0\u201c" + dynamicFieldCode + "\u201d\u5b57\u6bb5\u7684\u7c7b\u578b\u4e3a\u96c6\u5408\uff0c\u8bf7\u68c0\u67e5!!");
            return null;
        }
        Class collectionClass = dynamicFieldConfiguration.getCollectionClass();
        DynamicFormServiceOpStrategy currentDynamicFormServiceOpStrategy = this.findDynamicFormServiceOpStrategy(this.dynamicFormServiceOpStraties, isValueCollection, collectionClass);
        if (currentDynamicFormServiceOpStrategy == null) {
            LOGGER.warn("\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u6570\u636e\u67e5\u8be2\u65f6\uff0c\u53d1\u73b0\u201c" + dynamicFieldCode + "\u201d\u7684\u7c7b\u578b\u548cjson\u7ed3\u6784\u7684\u503c\u4e0d\u80fd\u5bf9\u5e94\uff08json\u4e3a\u6570\u7ec4\uff09\uff0c\u8bf7\u68c0\u67e5!!");
            return null;
        }
        if (StringUtils.indexOfAny((CharSequence)dynamicKey, (CharSequence[])dynamicKeys) == -1) {
            return null;
        }
        String dynamicFormCode = dynamicFieldConfiguration.findDynamicFormCodeByDynamicKey(dynamicKey);
        OperationStrategy<? extends DynamicForm> operationStrategy = DynamicFormUtils.findByDynamicFormCode(dynamicFormCode, this.operationStraties);
        if (operationStrategy == null) {
            return null;
        }
        Validate.isTrue((boolean)dclass.isAssignableFrom(operationStrategy.dynamicFormClass()), (String)"\u8fdb\u884c\u52a8\u6001\u6a21\u578b\u6570\u636e\u67e5\u8be2\u65f6\uff0c\u53d1\u73b0\u8981\u6c42\u8fd4\u56de\u7684\u7c7b\u578b\u548c\u67e5\u8be2\u51fa\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Collection results = (Collection)currentDynamicFormServiceOpStrategy.findByParentCode(operationStrategy, dynamicKey, parentCode);
        return results;
    }
}

