package com.biz.crm.common.form.local.service.internal;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.biz.crm.common.form.local.utils.DynamicFormUtils;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.biz.crm.common.form.sdk.model.OperationStrategyService;
import com.biz.crm.common.form.sdk.vo.DynamicFormVo;

@Service
public class OperationStrategyServiceImpl implements OperationStrategyService {

  @Autowired(required = false)
  private List<OperationStrategy<? extends DynamicForm>> operationStraties; 
  @Autowired
  private ApplicationContext applicationContext;
  
  @Override
  public DynamicFormVo findByDynamicFormCode(String dynamicFormCode) {
    if(StringUtils.isBlank(dynamicFormCode) || CollectionUtils.isEmpty(operationStraties)) {
      return null;
    }
    
    // 寻找对应的OperationStrategy
    OperationStrategy<? extends DynamicForm> selectedOperationStrategy = null;
    for (OperationStrategy<? extends DynamicForm> operationStrategy : operationStraties) {
      if(!StringUtils.equals(operationStrategy.dynamicFormCode(), dynamicFormCode)) {
        continue;
      }
      selectedOperationStrategy = operationStrategy;
    }
    if(selectedOperationStrategy == null) {
      return null;
    }
    
    // 现在进行动态表单的结构解析
    Class<? extends DynamicForm> dynamicFormClass = selectedOperationStrategy.dynamicFormClass();
    DynamicFormVo dynamicFormVo = DynamicFormUtils.analysis(dynamicFormClass , this.applicationContext);
    dynamicFormVo.setDynamicFormCode(dynamicFormCode);
    return dynamicFormVo;
  }
}
