/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.service.internal;

import com.biz.crm.common.form.local.entity.DynamicFormFieldMapping;
import com.biz.crm.common.form.local.repository.DynamicFormFieldMappingRepository;
import com.biz.crm.common.form.sdk.DynamicFormFieldMappingService;
import com.biz.crm.common.form.sdk.dto.DynamicFormFieldMappingRebindDto;
import com.biz.crm.common.form.sdk.model.OperationStrategyService;
import com.biz.crm.common.form.sdk.vo.DynamicChildrenFormVo;
import com.biz.crm.common.form.sdk.vo.DynamicFieldVo;
import com.biz.crm.common.form.sdk.vo.DynamicFormVo;
import com.biz.crm.common.form.sdk.vo.IDynamicForm;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DynamicFormFieldMappingServiceImpl
implements DynamicFormFieldMappingService {
    @Autowired
    private OperationStrategyService operationStrategyService;
    @Autowired
    private DynamicFormFieldMappingRepository dynamicFormFieldMappingRepository;

    public DynamicFormVo findByDynamicFormCode(String dynamicFormCode) {
        if (StringUtils.isBlank((CharSequence)dynamicFormCode)) {
            return null;
        }
        return this.operationStrategyService.findByDynamicFormCode(dynamicFormCode);
    }

    public DynamicFormVo findByDynamicFormCodeAndMappingCode(String dynamicFormCode, String mappingCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dynamicFormCode, mappingCode})) {
            return null;
        }
        DynamicFormVo dynamicForm = this.operationStrategyService.findByDynamicFormCode(dynamicFormCode);
        if (dynamicForm == null || CollectionUtils.isEmpty((Collection)dynamicForm.getDynamicFields())) {
            return null;
        }
        List<DynamicFormFieldMapping> dynamicFormFields = this.dynamicFormFieldMappingRepository.findByDynamicFormCodeAndMappingCode(dynamicFormCode, mappingCode);
        if (CollectionUtils.isEmpty(dynamicFormFields)) {
            return dynamicForm;
        }
        this.buildDynamicFields("", (IDynamicForm)dynamicForm, dynamicFormFields);
        return dynamicForm;
    }

    private void buildDynamicFields(String parentFieldCode, IDynamicForm currentDynamiForm, List<DynamicFormFieldMapping> dynamicFormFields) {
        List dynamicFields = currentDynamiForm.getDynamicFields();
        List childrenForms = currentDynamiForm.getChildrenForms();
        if (CollectionUtils.isEmpty((Collection)dynamicFields)) {
            return;
        }
        Map<String, DynamicFieldVo> dynamicFieldMappings = dynamicFields.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getFieldCode())).collect(Collectors.toMap(DynamicFieldVo::getFieldCode, item -> item, (entity1, entity2) -> entity1));
        List currentLevelDynamicFormFields = null;
        String prefixKey = "";
        if (StringUtils.isNotBlank((CharSequence)parentFieldCode)) {
            prefixKey = StringUtils.join((Object[])new String[]{parentFieldCode, "."});
            currentLevelDynamicFormFields = dynamicFormFields.stream().filter(item -> StringUtils.indexOf((CharSequence)item.getFieldCode(), (CharSequence)StringUtils.join((Object[])new String[]{parentFieldCode, "."})) == 0).collect(Collectors.toList());
        } else {
            currentLevelDynamicFormFields = dynamicFormFields.stream().filter(item -> StringUtils.indexOf((CharSequence)item.getFieldCode(), (CharSequence)".") == -1).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(currentLevelDynamicFormFields)) {
            currentDynamiForm.setDynamicFields(null);
            currentDynamiForm.setChildrenForms(null);
            return;
        }
        ArrayList resultDynamicFields = Lists.newArrayList();
        ArrayList resultChildrenForms = Lists.newArrayList();
        Map<Object, Object> resultChildrenFormsMapping = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)childrenForms)) {
            resultChildrenFormsMapping = childrenForms.stream().collect(Collectors.toMap(DynamicChildrenFormVo::getParentFieldCode, item -> item));
        }
        for (DynamicFormFieldMapping currentDynamicFormFieldMapping : currentLevelDynamicFormFields) {
            DynamicFieldVo currentDynamicFieldVo;
            String dynamicFieldCode = currentDynamicFormFieldMapping.getFieldCode();
            String dynamicFieldCodeNoPrefix = StringUtils.substringAfter((String)dynamicFieldCode, (String)prefixKey);
            if (StringUtils.isBlank((CharSequence)dynamicFieldCode) || (currentDynamicFieldVo = dynamicFieldMappings.get(dynamicFieldCodeNoPrefix)) == null) continue;
            if (currentDynamicFormFieldMapping.getNullable() != null) {
                currentDynamicFieldVo.setRequired(currentDynamicFormFieldMapping.getNullable() == false);
            }
            if (StringUtils.isNotBlank((CharSequence)currentDynamicFormFieldMapping.getFieldName())) {
                currentDynamicFieldVo.setFieldName(currentDynamicFormFieldMapping.getFieldName());
            }
            resultDynamicFields.add(currentDynamicFieldVo);
            DynamicChildrenFormVo currentDynamicChildrenForm = (DynamicChildrenFormVo)resultChildrenFormsMapping.get(dynamicFieldCodeNoPrefix);
            if (CollectionUtils.isEmpty((Collection)childrenForms) || currentDynamicChildrenForm == null) continue;
            this.buildDynamicFields(dynamicFieldCode, (IDynamicForm)currentDynamicChildrenForm, dynamicFormFields);
            resultChildrenForms.add(currentDynamicChildrenForm);
        }
        currentDynamiForm.setDynamicFields((List)resultDynamicFields);
        currentDynamiForm.setChildrenForms((List)resultChildrenForms);
    }

    @Transactional
    public void rebinding(String dynamicFormCode, String mappingCode, List<String> fieldCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(fieldCodes) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u88ab\u7ed1\u5b9a\u7684\u5b57\u6bb5\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        int len = fieldCodes.size();
        Object[] nullableArray = new Boolean[len];
        Arrays.fill(nullableArray, Boolean.TRUE);
        this.rebinding(dynamicFormCode, mappingCode, fieldCodes, Lists.newArrayList((Object[])nullableArray));
    }

    @Transactional
    public void rebinding(String dynamicFormCode, String mappingCode, List<String> fieldCodes, List<Boolean> nullables) {
        this.rebinding(dynamicFormCode, mappingCode, fieldCodes, nullables, null, null);
    }

    public void rebinding(String dynamicFormCode, String mappingCode, List<String> fieldCodes, List<Boolean> nullables, List<Integer> sortIndexs, List<String> groupIndexs) {
        DynamicFormFieldMappingRebindDto rebindDto = new DynamicFormFieldMappingRebindDto();
        rebindDto.setDynamicFormCode(dynamicFormCode);
        rebindDto.setFieldNames(null);
        rebindDto.setFieldCodes(fieldCodes);
        rebindDto.setNullables(nullables);
        rebindDto.setMappingCode(mappingCode);
        rebindDto.setGroupIndexs(groupIndexs);
        rebindDto.setSortIndexs(sortIndexs);
        this.rebinding(rebindDto);
    }

    public void rebinding(DynamicFormFieldMappingRebindDto dto) {
        String dynamicFormCode = dto.getDynamicFormCode();
        String mappingCode = dto.getMappingCode();
        List fieldCodes = dto.getFieldCodes();
        List fieldNames = dto.getFieldNames();
        List nullables = dto.getNullables();
        List sortIndexs = dto.getSortIndexs();
        List groupIndexs = dto.getGroupIndexs();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)fieldCodes) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u88ab\u7ed1\u5b9a\u7684\u5b57\u6bb5\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)nullables) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u88ab\u7ed1\u5b9a\u7684\u5b57\u6bb5\u5fc5\u987b\u8bbe\u5b9a\u201c\u662f\u5426\u5fc5\u586b\u4fe1\u606f\u201d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u52a8\u6001\u8868\u5355\u7f16\u53f7dynamicFormCode\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        DynamicFormVo currentDynamicForm = this.operationStrategyService.findByDynamicFormCode(dynamicFormCode);
        ArrayList reducedsFieldCodes = Lists.newArrayList();
        LinkedHashMap dynamicFieldMapping = Maps.newLinkedHashMap();
        this.findAllFieldCodes("", currentDynamicForm.getChildrenForms(), currentDynamicForm.getDynamicFields(), reducedsFieldCodes, dynamicFieldMapping);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)reducedsFieldCodes) ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u672a\u53d1\u73b0\u5f53\u524d\u52a8\u6001\u8868\u5355\u8bbe\u7f6e\u4e86\u4efb\u4f55\u5b57\u6bb5\u6ce8\u89e3\uff08@DynamicField\uff09\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)currentDynamicForm, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u52a8\u6001\u8868\u5355", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)mappingCode, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u6620\u5c04\u4e1a\u52a1\u7f16\u53f7mappingCode\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Set distinctFieldCodes = fieldCodes.stream().distinct().collect(Collectors.toSet());
        Validate.isTrue((distinctFieldCodes.size() == fieldCodes.size() ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u81f3\u5c11\u5b58\u5728\u4e00\u4e2a\u91cd\u590d\u7684\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)Sets.difference(distinctFieldCodes, (Set)Sets.newHashSet((Iterable)reducedsFieldCodes)).isEmpty(), (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u8981\u6c42\u7ed1\u5b9a\u7684\u5b57\u6bb5\u4e0d\u5c5e\u4e8e\u6307\u5b9a\u7684\u52a8\u6001\u8868\u5355\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((distinctFieldCodes.size() == nullables.size() ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u53d1\u73b0\u5b57\u6bb5\u548c\u5b57\u6bb5\u7684\u5fc5\u586b\u9879\u8bbe\u5b9a\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)fieldNames)) {
            Validate.isTrue((distinctFieldCodes.size() == fieldNames.size() ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u53d1\u73b0\u5b57\u6bb5\u548c\u5b57\u6bb5\u540d\u79f0\u8bbe\u5b9a\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        int index = 0;
        for (String fieldCode : fieldCodes) {
            DynamicFieldVo dynamicField = (DynamicFieldVo)dynamicFieldMapping.get(fieldCode);
            Validate.notNull((Object)dynamicField, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u5728\u64cd\u4f5c\u65f6\u53ef\u4ee5\u53d1\u73b0\u5b57\u6bb5%s\u5e76\u4e0d\u5728\u52a8\u6001\u8868\u5355\u4e2d\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{fieldCode});
            boolean isRequired = dynamicField.isRequired();
            if (isRequired) {
                Validate.isTrue(((Boolean)nullables.get(index) == false ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u53d1\u73b0\u5b57\u6bb5[%s]\u5728\u6280\u672f\u5c42\u9762\u8bbe\u7f6e\u4e3a\u5fc5\u586b\uff0c\u6240\u4ee5\u8be5\u5b57\u6bb5\u4e0d\u80fd\u7531\u4f7f\u7528\u8005\u8bbe\u7f6e\u4e3a\u975e\u5fc5\u586b", (Object[])new Object[]{fieldCode});
            }
            ++index;
        }
        List currentSortIndes = sortIndexs;
        if (CollectionUtils.isEmpty((Collection)currentSortIndes)) {
            currentSortIndes = Lists.newArrayList();
            for (int sortIndex = 0; sortIndex < fieldCodes.size(); ++sortIndex) {
                currentSortIndes.add(sortIndex);
            }
        } else {
            Validate.isTrue((fieldCodes.size() == currentSortIndes.size() ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u53d1\u73b0\u4f20\u5165\u7684\u6392\u5e8f\u4fe1\u606f\u548c\u5b57\u6bb5\u4fe1\u606f\u7684\u6570\u91cf\u4e0d\u543b\u5408", (Object[])new Object[0]);
            Validate.isTrue((currentSortIndes.size() == (int)currentSortIndes.stream().filter(item -> item != null).distinct().count() ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u53d1\u73b0\u4f20\u5165\u7684\u6392\u5e8f\u4fe1\u606f\u5b58\u5728\u7a7a\u503c\u6216\u8005\u91cd\u590d\u503c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
        List currentGroupIndexs = groupIndexs;
        if (CollectionUtils.isEmpty((Collection)currentGroupIndexs)) {
            currentGroupIndexs = Lists.newArrayList();
            for (int groupIndex = 0; groupIndex < fieldCodes.size(); ++groupIndex) {
                currentGroupIndexs.add(null);
            }
        } else {
            Validate.isTrue((fieldCodes.size() == currentGroupIndexs.size() ? 1 : 0) != 0, (String)"\u8fdb\u884c\u5b57\u6bb5\u7ed1\u5b9a/\u91cd\u7ed1\u5b9a\u65f6\uff0c\u53d1\u73b0\u4f20\u5165\u7684\u5206\u7ec4\u4fe1\u606f\u548c\u5b57\u6bb5\u4fe1\u606f\u7684\u6570\u91cf\u4e0d\u543b\u5408", (Object[])new Object[0]);
        }
        this.dynamicFormFieldMappingRepository.deleteByDynamicFormCodeAndMappingCode(dynamicFormCode, mappingCode);
        this.dynamicFormFieldMappingRepository.flush();
        index = 0;
        for (String fieldCode : fieldCodes) {
            DynamicFormFieldMapping dynamicFormFieldMapping = new DynamicFormFieldMapping();
            Boolean nullable = (Boolean)nullables.get(index);
            Integer sortIndex = (Integer)currentSortIndes.get(index);
            String groupIndex = (String)currentGroupIndexs.get(index);
            if (!CollectionUtils.isEmpty((Collection)fieldNames)) {
                dynamicFormFieldMapping.setFieldName((String)fieldNames.get(index));
            }
            dynamicFormFieldMapping.setDynamicFormCode(dynamicFormCode);
            dynamicFormFieldMapping.setFieldCode(fieldCode);
            dynamicFormFieldMapping.setMappingCode(mappingCode);
            dynamicFormFieldMapping.setNullable(nullable);
            dynamicFormFieldMapping.setSortIndex(sortIndex);
            dynamicFormFieldMapping.setGroupIndex(groupIndex);
            this.dynamicFormFieldMappingRepository.save((Object)dynamicFormFieldMapping);
            ++index;
        }
    }

    private void findAllFieldCodes(String parentFieldCode, List<DynamicChildrenFormVo> childrenForms, List<DynamicFieldVo> dynamicFields, List<String> reducedsFieldCodes, Map<String, DynamicFieldVo> dynamicFieldMapping) {
        if (!CollectionUtils.isEmpty(dynamicFields)) {
            for (DynamicFieldVo dynamicField : dynamicFields) {
                String fieldCode = dynamicField.getFieldCode();
                if (StringUtils.isBlank((CharSequence)parentFieldCode)) {
                    reducedsFieldCodes.add(fieldCode);
                    dynamicFieldMapping.put(fieldCode, dynamicField);
                    continue;
                }
                reducedsFieldCodes.add(StringUtils.join((Object[])new String[]{parentFieldCode, ".", fieldCode}));
                dynamicFieldMapping.put(StringUtils.join((Object[])new String[]{parentFieldCode, ".", fieldCode}), dynamicField);
            }
        }
        if (!CollectionUtils.isEmpty(childrenForms)) {
            for (DynamicChildrenFormVo dynamicChildrenForm : childrenForms) {
                String currentParentFieldCode = null;
                currentParentFieldCode = StringUtils.isBlank((CharSequence)parentFieldCode) ? dynamicChildrenForm.getParentFieldCode() : StringUtils.join((Object[])new String[]{parentFieldCode, ".", dynamicChildrenForm.getParentFieldCode()});
                this.findAllFieldCodes(currentParentFieldCode, dynamicChildrenForm.getChildrenForms(), dynamicChildrenForm.getDynamicFields(), reducedsFieldCodes, dynamicFieldMapping);
            }
        }
    }
}

