/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.service.op;

import com.biz.crm.common.form.sdk.field.ValidateStrategy;
import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class AbstractDynamicFormServiceOpStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDynamicFormServiceOpStrategy.class);
    @Autowired
    private ApplicationContext applicationContext;

    protected void fieldValidate(Field declaredField, DynamicForm dynamicFormObject, Object mainForm) {
        DynamicField dynamicFieldAnnotation = declaredField.getAnnotation(DynamicField.class);
        if (dynamicFieldAnnotation == null) {
            return;
        }
        Validate[] validateAnnotations = dynamicFieldAnnotation.validates();
        if (validateAnnotations == null || validateAnnotations.length == 0) {
            return;
        }
        Object declaredFieldValue = null;
        try {
            declaredFieldValue = declaredField.get(dynamicFormObject);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return;
        }
        String declaredFieldName = declaredField.getName();
        for (Validate validate : validateAnnotations) {
            Class validateStrategyClass = validate.value();
            if (validateStrategyClass == null) continue;
            ValidateStrategy validateStrategy = null;
            Object[] inputs = validate.inputs();
            validateStrategy = inputs == null || inputs.length == 0 ? (ValidateStrategy)this.applicationContext.getBean(validateStrategyClass) : (ValidateStrategy)this.applicationContext.getBean(validateStrategyClass, inputs);
            validateStrategy.validate(declaredFieldValue, declaredFieldName, declaredField, mainForm);
        }
    }
}

