package com.biz.crm.common.form.local.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.biz.crm.common.form.local.entity.DynamicFormFieldMapping;

/**
 * 注释未写
 * @author yinwenjie
 */
@Repository("dynamicFormFieldMappingRepository")
public interface DynamicFormFieldMappingRepository
    extends
    JpaRepository<DynamicFormFieldMapping, String>,
    JpaSpecificationExecutor<DynamicFormFieldMapping> {
  
  @Query("from DynamicFormFieldMapping d where d.mappingCode = :mappingCode and d.dynamicFormCode = :dynamicFormCode order by sortIndex ")
  List<DynamicFormFieldMapping> findByDynamicFormCodeAndMappingCode(@Param("dynamicFormCode") String dynamicFormCode , @Param("mappingCode")  String mappingCode);
  
  @Modifying
  @Query("delete from DynamicFormFieldMapping d where d.mappingCode = :mappingCode and d.dynamicFormCode = :dynamicFormCode ")
  void deleteByDynamicFormCodeAndMappingCode(@Param("dynamicFormCode") String dynamicFormCode , @Param("mappingCode")  String mappingCode);
}