/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.builder;

import com.biz.crm.common.form.local.utils.DynamicFormUtils;
import com.biz.crm.common.form.sdk.DynamicFieldConfiguration;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.DynamicFormServiceBuilder;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

public class DynamicFormServiceLocalBuilder<T>
implements DynamicFormServiceBuilder<T> {
    private Class<T> formClass;
    private Map<String, DynamicFieldConfiguration<T>> dynamicFieldConfigurationMapping = Maps.newLinkedHashMap();
    private ApplicationContext applicationContext;
    @Autowired
    private List<OperationStrategy<? extends DynamicForm>> operationStraties;
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormServiceLocalBuilder.class);

    public DynamicFormServiceLocalBuilder(Class<T> formClass, ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        Validate.notNull((Object)applicationContext, (String)"\u672a\u53d1\u73b0application\u670d\u52a1\u4e0a\u4e0b\u6587!!", (Object[])new Object[0]);
        this.formClass = formClass;
    }

    public <R> DynamicFieldConfiguration<T> dynamicField(String field) {
        Validate.notBlank((CharSequence)field, (String)"\u751f\u6210\u52a8\u6001\u8868\u5355\u670d\u52a1\u65f6\uff0c\u6784\u5efa\u8005\u5fc5\u987b\u4f20\u5165\u6b63\u786e\u7684field\u4fe1\u606f", (Object[])new Object[0]);
        Field declaredField = null;
        try {
            declaredField = this.formClass.getDeclaredField(field);
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u751f\u6210\u52a8\u6001\u8868\u5355\u670d\u52a1\u65f6\uff0c\u6784\u5efa\u8005\u672a\u627e\u5230\u6b63\u786e\u7684field\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", e);
        }
        Triple<Class<?>, Boolean, Class<?>> fieldAnalysisResult = DynamicFormUtils.analysisMapFieldType(declaredField);
        Class valueClass = (Class)fieldAnalysisResult.getLeft();
        Boolean isValueCollection = (Boolean)fieldAnalysisResult.getMiddle();
        Class collectionClass = (Class)fieldAnalysisResult.getRight();
        DynamicFieldLocalConfiguration dynamicFieldLocalConfiguration = new DynamicFieldLocalConfiguration(this, field, valueClass, isValueCollection, collectionClass);
        this.dynamicFieldConfigurationMapping.put(field, dynamicFieldLocalConfiguration);
        return dynamicFieldLocalConfiguration;
    }

    public DynamicFormService<T> build() {
        Validate.isTrue((!CollectionUtils.isEmpty(this.dynamicFieldConfigurationMapping) ? 1 : 0) != 0, (String)"\u751f\u6210\u52a8\u6001\u8868\u5355\u670d\u52a1\u65f6\uff0c\u81f3\u5c11\u8bbe\u5b9a\u4e00\u4e2a\u4e3b\u6a21\u578b\u4e0a\u7684\u5b57\u6bb5/\u5c5e\u6027\uff0c\u4e3a\u52a8\u6001\u8868\u5355\u6a21\u578b\u7ed3\u6784!!", (Object[])new Object[0]);
        for (Map.Entry<String, DynamicFieldConfiguration<T>> entrySetItem : this.dynamicFieldConfigurationMapping.entrySet()) {
            DynamicFieldConfiguration<T> dynamicFieldConfiguration = entrySetItem.getValue();
            String field = dynamicFieldConfiguration.getField();
            Validate.notBlank((CharSequence)field, (String)"\u751f\u6210\u52a8\u6001\u8868\u5355\u670d\u52a1\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u4e3b\u6a21\u578b\u8bbe\u7f6e\u9879\u6ca1\u6709\u6b63\u786e\u8bbe\u5b9a\u5b57\u6bb5/\u5c5e\u6027\u4fe1\u606f", (Object[])new Object[0]);
            String[] dynamicKeys = dynamicFieldConfiguration.findDynamicKeys();
            Validate.isTrue((dynamicKeys != null && dynamicKeys.length > 0 ? 1 : 0) != 0, (String)"\u751f\u6210\u52a8\u6001\u8868\u5355\u670d\u52a1\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u4e3b\u6a21\u578b\u8bbe\u7f6e\u8bbe\u5b9a\u7684\u5b57\u6bb5/\u5c5e\u6027\u4fe1\u606f\u6ca1\u6709\u8bbe\u5b9a\u6620\u5c04\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            for (String dynamicKey : dynamicKeys) {
                String dynamicFormCode = dynamicFieldConfiguration.findDynamicFormCodeByDynamicKey(dynamicKey);
                Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u751f\u6210\u52a8\u6001\u8868\u5355\u670d\u52a1\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u4e00\u4e2a\u5b57\u6bb5/\u5c5e\u6027\uff0c\u8bbe\u5b9a\u7684\u6620\u5c04\u4fe1\u606f\uff0c\u627e\u4e0d\u5230\u6620\u5c04\u503c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                Validate.notNull(DynamicFormUtils.findByDynamicFormCode(dynamicFormCode, this.operationStraties), (String)"\u751f\u6210\u52a8\u6001\u8868\u5355\u670d\u52a1\u65f6\uff0c\u672a\u53d1\u73b0\u5339\u914d\u7684\u5904\u7406\u7b56\u7565\uff08%s\uff09", (Object[])new Object[]{dynamicFormCode});
            }
        }
        DynamicFormService dynamicFormService = (DynamicFormService)this.applicationContext.getBean(DynamicFormService.class, new Object[]{this.formClass, this.dynamicFieldConfigurationMapping});
        return dynamicFormService;
    }

    public class DynamicFieldLocalConfiguration
    implements DynamicFieldConfiguration<T> {
        private DynamicFormServiceLocalBuilder<T> dynamicFormServiceBuilder;
        private String field;
        private Class<?> valueClass;
        private Boolean isValueCollection;
        private Class<?> collectionClass;
        private Map<String, String> dynamicMapping = Maps.newLinkedHashMap();

        public DynamicFieldLocalConfiguration(DynamicFormServiceLocalBuilder<T> dynamicFormServiceBuilder, String field, Class<?> valueClass, Boolean isValueCollection, Class<?> collectionClass) {
            this.dynamicFormServiceBuilder = dynamicFormServiceBuilder;
            this.field = field;
            this.valueClass = valueClass;
            this.isValueCollection = isValueCollection;
            this.collectionClass = collectionClass;
        }

        public DynamicFieldConfiguration<T> addDynamicMapping(String dynamicKey, String dynamicFormCode) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dynamicKey, dynamicFormCode})) {
                throw new IllegalArgumentException("\u9519\u8bef\u7684\u5165\u53c2\u4fe1\u606f\uff0cdynamicKey\u548cdynamicFormCode\u5fc5\u987b\u90fd\u8fdb\u884c\u586b\u5199");
            }
            this.dynamicMapping.put(dynamicKey, dynamicFormCode);
            return this;
        }

        public DynamicFormServiceBuilder<T> config() {
            return this.dynamicFormServiceBuilder;
        }

        public String findDynamicFormCodeByDynamicKey(String dynamicKey) {
            return this.dynamicMapping.get(dynamicKey);
        }

        public String[] findDynamicKeys() {
            Set<String> keys = this.dynamicMapping.keySet();
            if (CollectionUtils.isEmpty(keys)) {
                return null;
            }
            return keys.toArray(new String[0]);
        }

        public String getField() {
            return this.field;
        }

        public Class<?> getValueClass() {
            return this.valueClass;
        }

        public boolean isValueCollection() {
            return this.isValueCollection;
        }

        public Class<?> getCollectionClass() {
            return this.collectionClass;
        }
    }
}

