/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.utils;

import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.biz.crm.common.form.sdk.vo.DynamicChildrenFormVo;
import com.biz.crm.common.form.sdk.vo.DynamicFieldVo;
import com.biz.crm.common.form.sdk.vo.DynamicFormVo;
import com.biz.crm.common.form.sdk.widget.WidgetKey;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

public final class DynamicFormUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormUtils.class);

    private DynamicFormUtils() {
    }

    public static DynamicFormVo analysis(Class<? extends DynamicForm> dynamicFormClass, ApplicationContext applicationContext) {
        if (dynamicFormClass == null) {
            return null;
        }
        ArrayList childrenForms = Lists.newArrayList();
        ArrayList dynamicFields = Lists.newArrayList();
        DynamicFormUtils.buildSuperForm(dynamicFormClass, dynamicFields, childrenForms, applicationContext);
        DynamicFormVo dynamicFormVo = new DynamicFormVo();
        dynamicFormVo.setDynamicFields((List)dynamicFields);
        dynamicFormVo.setChildrenForms((List)childrenForms);
        return dynamicFormVo;
    }

    private static void buildSuperForm(Class<?> dynamicFormClass, List<DynamicFieldVo> dynamicFields, List<DynamicChildrenFormVo> childrenForms, ApplicationContext applicationContext) {
        Class<?> superClass = dynamicFormClass.getSuperclass();
        if (superClass != null) {
            DynamicFormUtils.buildSuperForm(superClass, dynamicFields, childrenForms, applicationContext);
        }
        Field[] declaredFields = dynamicFormClass.getDeclaredFields();
        List<Object> currentDynamicFields = Lists.newArrayList();
        if (declaredFields != null && declaredFields.length > 0) {
            currentDynamicFields = DynamicFormUtils.buildDynamicFields(declaredFields, applicationContext);
        }
        dynamicFields.addAll((Collection<DynamicFieldVo>)currentDynamicFields);
        ArrayList currentChildrenForms = Lists.newArrayList();
        for (DynamicFieldVo dynamicFieldVo : currentDynamicFields) {
            if (!DynamicFormUtils.isChildrenForm(dynamicFieldVo)) continue;
            DynamicChildrenFormVo buildChildrenForm = DynamicFormUtils.buildChildrenForm(dynamicFieldVo, applicationContext);
            currentChildrenForms.add(buildChildrenForm);
        }
        childrenForms.addAll(currentChildrenForms);
    }

    private static DynamicChildrenFormVo buildChildrenForm(DynamicFieldVo dynamicFieldVo, ApplicationContext applicationContext) {
        DynamicChildrenFormVo dynamicChildrenForm = new DynamicChildrenFormVo();
        dynamicChildrenForm.setParentFieldCode(dynamicFieldVo.getFieldCode());
        Class dynamicFormClass = dynamicFieldVo.getFieldClass();
        Field[] declaredFields = dynamicFormClass.getDeclaredFields();
        List<Object> dynamicFields = Lists.newArrayList();
        if (declaredFields != null && declaredFields.length > 0) {
            dynamicFields = DynamicFormUtils.buildDynamicFields(declaredFields, applicationContext);
        }
        dynamicChildrenForm.setDynamicFields((List)dynamicFields);
        ArrayList childrenForms = Lists.newArrayList();
        for (DynamicFieldVo dynamicFieldItem : dynamicFields) {
            if (!DynamicFormUtils.isChildrenForm(dynamicFieldItem)) continue;
            DynamicChildrenFormVo buildChildrenForm = DynamicFormUtils.buildChildrenForm(dynamicFieldItem, applicationContext);
            childrenForms.add(buildChildrenForm);
        }
        dynamicChildrenForm.setChildrenForms((List)childrenForms);
        return dynamicChildrenForm;
    }

    private static List<DynamicFieldVo> buildDynamicFields(Field[] declaredFields, ApplicationContext applicationContext) {
        ArrayList dynamicFields = Lists.newArrayList();
        for (Field declaredField : declaredFields) {
            DynamicField dynamicFieldAnnotation = declaredField.getAnnotation(DynamicField.class);
            if (dynamicFieldAnnotation == null) continue;
            String fieldName = dynamicFieldAnnotation.fieldName();
            boolean required = dynamicFieldAnnotation.required();
            boolean modifiable = dynamicFieldAnnotation.modifiable();
            Validate[] validates = dynamicFieldAnnotation.validates();
            Class controllKeyClass = dynamicFieldAnnotation.controllKey();
            WidgetKey widgetKey = null;
            if (controllKeyClass != null && applicationContext != null) {
                widgetKey = (WidgetKey)applicationContext.getBean(controllKeyClass);
            } else if (controllKeyClass != null && applicationContext == null) {
                try {
                    widgetKey = (WidgetKey)controllKeyClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException(e.getMessage());
                }
            }
            Triple<Class<?>, Boolean, Class<?>> fieldAnalysisResult = DynamicFormUtils.analysisFieldType(declaredField);
            Class valueClass = (Class)fieldAnalysisResult.getLeft();
            Boolean isValueCollection = (Boolean)fieldAnalysisResult.getMiddle();
            Boolean array = valueClass.isArray();
            String fieldCode = declaredField.getName();
            DynamicFieldVo dynamicFieldVo = new DynamicFieldVo();
            dynamicFieldVo.setArray(array);
            dynamicFieldVo.setCollection(isValueCollection);
            dynamicFieldVo.setControllKey(widgetKey);
            dynamicFieldVo.setField(declaredField);
            dynamicFieldVo.setFieldClass(valueClass);
            dynamicFieldVo.setFieldCode(fieldCode);
            dynamicFieldVo.setFieldName(fieldName);
            dynamicFieldVo.setRequired(required);
            dynamicFieldVo.setModifiable(modifiable);
            dynamicFieldVo.setValidates(validates);
            dynamicFields.add(dynamicFieldVo);
        }
        return dynamicFields;
    }

    private static boolean isChildrenForm(DynamicFieldVo dynamicFieldVo) {
        Class fieldClass = dynamicFieldVo.getFieldClass();
        boolean isPrimitive = fieldClass.isPrimitive();
        String classFullName = fieldClass.getName();
        ClassLoader classLoader = fieldClass.getClassLoader();
        Field[] declaredChildFields = fieldClass.getDeclaredFields();
        boolean hasAnnotation = false;
        for (Field declaredChildFieldItem : declaredChildFields) {
            DynamicField dynamicFieldAnnotation = declaredChildFieldItem.getAnnotation(DynamicField.class);
            if (dynamicFieldAnnotation == null) continue;
            hasAnnotation = true;
            break;
        }
        if (isPrimitive) {
            return false;
        }
        if (StringUtils.indexOfAny((CharSequence)classFullName, (CharSequence[])new CharSequence[]{"java.", "javax.", "org.springframework."}) != -1) {
            return false;
        }
        if (classLoader == null || !URLClassLoader.class.isAssignableFrom(classLoader.getClass())) {
            return false;
        }
        return hasAnnotation;
    }

    public static Triple<Class<?>, Boolean, Class<?>> analysisMapFieldType(Field declaredField) {
        Class<?> mapDeclaredFieldType = declaredField.getType();
        String fieldName = declaredField.getName();
        if (!Map.class.isAssignableFrom(mapDeclaredFieldType)) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u7684\u5b57\u6bb5" + fieldName + "\uff0c\u5e76\u4e0d\u662fMap\u6027\u8d28\u7684\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5!!");
        }
        Type genericType = declaredField.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u7684Map\u6027\u8d28\u7684\u5b57\u6bb5" + fieldName + "\uff0c\u5b58\u5728\u65e0\u6cd5\u8bc6\u522b\u7684\u6cdb\u578b\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!");
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        Type keyType = actualTypeArguments[0];
        if (!(keyType instanceof Class) || !CharSequence.class.isAssignableFrom((Class)keyType)) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u7684Map\u6027\u8d28\u7684\u5b57\u6bb5" + fieldName + "\uff0c\u5176Key\u90e8\u5206\u7684\u7c7b\u578b\u5e76\u4e0d\u662f\u5b57\u7b26\u4e32\u6027\u8d28\uff0c\u8bf7\u68c0\u67e5!!");
        }
        Boolean isCollection = false;
        Class valueClass = null;
        Class collectionClass = null;
        try {
            Type valueType = actualTypeArguments[1];
            if (valueType instanceof ParameterizedType) {
                ParameterizedType valueParameterizedType = (ParameterizedType)valueType;
                valueType = valueParameterizedType.getActualTypeArguments()[0];
                valueClass = (Class)valueType;
                Type rawType = valueParameterizedType.getRawType();
                isCollection = Collection.class.isAssignableFrom((Class)rawType);
                if (isCollection.booleanValue()) {
                    collectionClass = (Class)rawType;
                }
            } else {
                valueClass = (Class)valueType;
            }
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("\u7ed9\u5b9a\u7684Map\u6027\u8d28\u7684\u5b57\u6bb5" + fieldName + "\uff0c\u5176value\u90e8\u5206\u4e0d\u7b26\u5408\u8bbe\u5b9a\u8981\u6c42(\u53ef\u80fd\u4e3a\u53cc\u96c6\u5408/\u53cc\u6cdb\u578b\u5d4c\u5957)\uff0c\u8bf7\u68c0\u67e5!!");
        }
        Triple triple = Triple.of((Object)valueClass, (Object)isCollection, collectionClass);
        return triple;
    }

    private static Triple<Class<?>, Boolean, Class<?>> analysisFieldType(Field declaredField) {
        Type genericType = declaredField.getGenericType();
        String fieldName = declaredField.getName();
        Boolean isCollection = false;
        Class valueClass = null;
        Class collectionClass = null;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            Type realType = actualTypeArguments[0];
            if (!(realType instanceof Class)) {
                throw new IllegalArgumentException("\u5b57\u6bb5\u5c5e\u6027\uff1a" + fieldName + "\uff0c\u5176\u7c7b\u578b\u5e76\u4e0d\u662f\u5b57\u7b26\u4e32\u6027\u8d28\uff0c\u8bf7\u68c0\u67e5!!");
            }
            valueClass = (Class)realType;
            Type rawType = parameterizedType.getRawType();
            isCollection = Collection.class.isAssignableFrom((Class)rawType);
            if (isCollection.booleanValue()) {
                collectionClass = (Class)rawType;
            }
        } else {
            valueClass = (Class)genericType;
        }
        Triple triple = Triple.of((Object)valueClass, (Object)isCollection, collectionClass);
        return triple;
    }

    public static OperationStrategy<? extends DynamicForm> findByDynamicFormCode(String dynamicFormCode, List<OperationStrategy<? extends DynamicForm>> operationStraties) {
        if (CollectionUtils.isEmpty(operationStraties)) {
            return null;
        }
        for (OperationStrategy<? extends DynamicForm> operationStrategy : operationStraties) {
            if (!StringUtils.equals((CharSequence)operationStrategy.dynamicFormCode(), (CharSequence)dynamicFormCode)) continue;
            return operationStrategy;
        }
        return null;
    }
}

