package com.biz.crm.common.form.local.config;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

import com.biz.crm.common.form.local.builder.DynamicFormServiceLocalBuilder;
import com.biz.crm.common.form.local.service.internal.DynamicFormServiceImpl;
import com.biz.crm.common.form.sdk.DynamicFieldConfiguration;
import com.biz.crm.common.form.sdk.DynamicFormService;

/**
 * CRM 3.0中为解决固定业务模型中的动态表单结构，所实现的技术方案——“动态表单结构”的标品配置信息
 * @author yinwenjie
 */
@Configuration
@ComponentScan(basePackages = {"com.biz.crm.common.form"})
@EntityScan(basePackages = "com.biz.crm.common.form.local.entity")
@EnableJpaRepositories(basePackages = "com.biz.crm.common.form.local.repository")
public class DynamicFormLocalConfig {
  /**
   * 具体的优惠政策加载任务（多例）
   * @return 
   */
  @Bean
  @Scope("prototype")
  public <T> DynamicFormService<T> getDynamicFormService(@Autowired(required = false) Class<T> formClass , Map<String , DynamicFieldConfiguration<T>> dynamicFieldConfigurationMapping) {
    return new DynamicFormServiceImpl<>(formClass , dynamicFieldConfigurationMapping);
  }
  
  @Bean
  @Scope("prototype") 
  public <T> DynamicFormServiceLocalBuilder<T> getDynamicFormServiceLocalBuilder(@Autowired(required = false) Class<T> formClass , ApplicationContext applicationContext) {
    return new DynamicFormServiceLocalBuilder<>(formClass , applicationContext); 
  }
}
