package com.biz.crm.common.form.local.controller;

import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.form.sdk.widget.WidgetKey;

import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@RestController
@RequestMapping(value = {"/v1/dynamicform/widgets"})
public class WidgetController {
  
  /**
   * 目前系统中所有的控件注册信息
   */
  @Autowired
  private Set<WidgetKey> widgets;
  
  @ApiOperation(value = "查询目前系统中所有的控件")
  @GetMapping(value = "/findAll")
  public Result<?> findAll() {
    try {
      JSONArray jsonArray = new JSONArray();
      for (WidgetKey widget : widgets) {
        String widgetCode = widget.widgetCode();
        String widgetName = widget.widgetName();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("widgetCode", widgetCode);
        jsonObject.put("widgetName", widgetName);
        jsonArray.add(jsonObject);
      }
      return Result.ok(jsonArray);
    } catch(RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
