/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.form.sdk.DynamicFormFieldMappingService;
import com.biz.crm.common.form.sdk.vo.DynamicChildrenFormVo;
import com.biz.crm.common.form.sdk.vo.DynamicFieldVo;
import com.biz.crm.common.form.sdk.vo.DynamicFormVo;
import com.biz.crm.common.form.sdk.widget.WidgetKey;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dynamicform/dynamicForms"})
public class DynamicFormController {
    private static final Logger log = LoggerFactory.getLogger(DynamicFormController.class);
    @Autowired
    private DynamicFormFieldMappingService dynamicFormFieldMappingService;

    @ApiOperation(value="\u6309\u7167\u52a8\u6001\u8868\u5355\u5728\u7cfb\u7edf\u4e2d\u552f\u4e00\u7684\u4e1a\u52a1\u7f16\u7801\u8fdb\u884c\u67e5\u8be2\uff0c\u6ce8\u610f\uff0c\u8fd9\u79cd\u67e5\u8be2\u65b9\u5f0f\uff0c\u5c06\u5ffd\u7565\u5bf9\u5b57\u6bb5\u9009\u62e9\u8303\u56f4\u7684\u8fc7\u6ee4\u3002\u610f\u601d\u5c31\u662f\u8bf4\u52a8\u6001\u8868\u5355\u4e2d\u6240\u6709\u7684\u4e1a\u52a1\u5b57\u6bb5\u90fd\u5c06\u88ab\u8fd4\u56de")
    @GetMapping(value={"findByDynamicFormCode"})
    public Result<?> findByDynamicFormCode(@RequestParam(value="dynamicFormCode") String dynamicFormCode) {
        try {
            DynamicFormVo dynamicForm = this.dynamicFormFieldMappingService.findByDynamicFormCode(dynamicFormCode);
            if (dynamicForm == null) {
                return Result.ok();
            }
            return Result.ok((Object)this.buildJson(dynamicForm));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6309\u7167\u52a8\u6001\u8868\u5355\u5728\u7cfb\u7edf\u4e2d\u552f\u4e00\u7684\u4e1a\u52a1\u7f16\u7801\u548c\u4e3a\u8fd9\u4e2a\u8868\u5355\u8bbe\u7f6e\u7684\u5b57\u6bb5\u6620\u5c04\u7f16\u53f7\u8fdb\u884c\u67e5\u8be2\uff0c\u8fd9\u79cd\u67e5\u8be2\u7ed3\u679c\u5c06\u53ea\u4f1a\u8fd4\u56de\u8fd9\u4e2a\u52a8\u6001\u8868\u5355\u4e2d\u548c\u8fd9\u4e2a\u6620\u5c04\u7f16\u53f7\u7ed1\u5b9a\u7684\u5b57\u6bb5\u4fe1\u606f")
    @GetMapping(value={"findByDynamicFormCodeAndMappingCode"})
    public Result<?> findByDynamicFormCodeAndMappingCode(@RequestParam(value="dynamicFormCode") String dynamicFormCode, @RequestParam(value="mappingCode") String mappingCode) {
        try {
            DynamicFormVo dynamicForm = this.dynamicFormFieldMappingService.findByDynamicFormCodeAndMappingCode(dynamicFormCode, mappingCode);
            if (dynamicForm == null) {
                return Result.ok();
            }
            return Result.ok((Object)this.buildJson(dynamicForm));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    private JSONObject buildJson(DynamicFormVo dynamicForm) {
        List childrenForms;
        JSONObject result = new JSONObject();
        result.put("dynamicFormCode", (Object)dynamicForm.getDynamicFormCode());
        List dynamicFields = dynamicForm.getDynamicFields();
        if (!CollectionUtils.isEmpty((Collection)dynamicFields)) {
            JSONArray dynamicFieldJsons = this.buildDynamicFieldJsons(dynamicFields);
            result.put("dynamicFields", (Object)dynamicFieldJsons);
        }
        if (!CollectionUtils.isEmpty((Collection)(childrenForms = dynamicForm.getChildrenForms()))) {
            JSONArray dynamicChildrenFormJsons = this.buildDynamicChildrenFormJsons(childrenForms);
            result.put("childrenForms", (Object)dynamicChildrenFormJsons);
        }
        return result;
    }

    private JSONArray buildDynamicChildrenFormJsons(List<DynamicChildrenFormVo> childrenForms) {
        JSONArray results = new JSONArray();
        if (CollectionUtils.isEmpty(childrenForms)) {
            return results;
        }
        for (DynamicChildrenFormVo dynamicChildrenForm : childrenForms) {
            List dynamicChildrenForms;
            JSONObject dynamicChildrenFormJson = new JSONObject();
            dynamicChildrenFormJson.put("parentFieldCode", (Object)dynamicChildrenForm.getParentFieldCode());
            List childDynamicFields = dynamicChildrenForm.getDynamicFields();
            if (!CollectionUtils.isEmpty((Collection)childDynamicFields)) {
                JSONArray dynamicFieldJsons = this.buildDynamicFieldJsons(childDynamicFields);
                dynamicChildrenFormJson.put("dynamicFields", (Object)dynamicFieldJsons);
            }
            if (!CollectionUtils.isEmpty((Collection)(dynamicChildrenForms = dynamicChildrenForm.getChildrenForms()))) {
                JSONArray dynamicChildrenFormJsons = this.buildDynamicChildrenFormJsons(dynamicChildrenForms);
                dynamicChildrenFormJson.put("childrenForms", (Object)dynamicChildrenFormJsons);
            }
            results.add((Object)dynamicChildrenFormJson);
        }
        return results;
    }

    private JSONArray buildDynamicFieldJsons(List<DynamicFieldVo> dynamicFields) {
        JSONArray dynamicFieldJsons = new JSONArray();
        if (CollectionUtils.isEmpty(dynamicFields)) {
            return dynamicFieldJsons;
        }
        for (DynamicFieldVo dynamicFieldVo : dynamicFields) {
            Class fieldClass = dynamicFieldVo.getFieldClass();
            Boolean array = dynamicFieldVo.getArray();
            Boolean collection = dynamicFieldVo.getCollection();
            String fieldName = dynamicFieldVo.getFieldName();
            String fieldCode = dynamicFieldVo.getFieldCode();
            boolean required = dynamicFieldVo.isRequired();
            boolean modifiable = dynamicFieldVo.isModifiable();
            Integer sortIndex = dynamicFieldVo.getSortIndex();
            String groupIndex = dynamicFieldVo.getGroupIndex();
            WidgetKey controllKey = dynamicFieldVo.getControllKey();
            JSONObject widgetKeyJson = new JSONObject();
            String widgetCode = controllKey.widgetCode();
            String widgetName = controllKey.widgetName();
            Map widgetParam = controllKey.widgetParam();
            widgetKeyJson.put("widgetCode", (Object)widgetCode);
            widgetKeyJson.put("widgetName", (Object)widgetName);
            widgetKeyJson.put("widgetParam", (Object)widgetParam);
            JSONObject dynamicFieldJson = new JSONObject();
            dynamicFieldJson.put("fieldClass", (Object)fieldClass);
            dynamicFieldJson.put("array", (Object)array);
            dynamicFieldJson.put("collection", (Object)collection);
            dynamicFieldJson.put("fieldName", (Object)fieldName);
            dynamicFieldJson.put("fieldCode", (Object)fieldCode);
            dynamicFieldJson.put("required", (Object)required);
            dynamicFieldJson.put("modifiable", (Object)modifiable);
            dynamicFieldJson.put("collection", (Object)collection);
            dynamicFieldJson.put("controllKey", (Object)widgetKeyJson);
            dynamicFieldJson.put("sortIndex", (Object)sortIndex);
            dynamicFieldJson.put("groupIndex", (Object)groupIndex);
            dynamicFieldJsons.add((Object)dynamicFieldJson);
        }
        return dynamicFieldJsons;
    }

    @ApiOperation(value="\u8be5\u65b9\u6cd5\u5c06\u5efa\u7acb/\u91cd\u65b0\u5efa\u7acb\u6307\u5b9a\u52a8\u6001\u8868\u5355\u4e0b\uff0c\u57fa\u4e8e\u67d0\u4e2a\u6620\u5c04\u7f16\u53f7\uff08\u53ef\u4ee5\u662f\u4efb\u610f\u4e1a\u52a1\u610f\u4e49\u7684\u5b57\u7b26\u4e32\uff09\uff0c\u6240\u7ed1\u5b9a\u7684\u52a8\u6001\u8868\u5355\u5b57\u6bb5\u4fe1\u606f\u3002\u6ce8\u610f\uff0c\u8fd9\u79cd\u60c5\u51b5\u4e0b\uff0c\u8868\u793a\u6240\u6709\u9009\u5b9a\u7684\u5b57\u6bb5\u90fd\u662f\u975e\u5fc5\u586b")
    @PostMapping(value={"rebinding"})
    public Result<?> rebinding(@RequestParam(value="dynamicFormCode") String dynamicFormCode, @RequestParam(value="mappingCode") String mappingCode, @RequestParam(value="fieldCode") String[] fieldCodes) {
        try {
            this.dynamicFormFieldMappingService.rebinding(dynamicFormCode, mappingCode, (List)Lists.newArrayList((Object[])fieldCodes));
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be5\u65b9\u6cd5\u5c06\u5efa\u7acb/\u91cd\u65b0\u5efa\u7acb\u6307\u5b9a\u52a8\u6001\u8868\u5355\u4e0b\uff0c\u57fa\u4e8e\u67d0\u4e2a\u6620\u5c04\u7f16\u53f7\uff08\u53ef\u4ee5\u662f\u4efb\u610f\u4e1a\u52a1\u610f\u4e49\u7684\u5b57\u7b26\u4e32\uff09\uff0c\u6240\u7ed1\u5b9a\u7684\u52a8\u6001\u8868\u5355\u5b57\u6bb5\u4fe1\u606f\u3002")
    @PostMapping(value={"rebindingSetNullables"})
    public Result<?> rebinding(@RequestParam(value="dynamicFormCode") String dynamicFormCode, @RequestParam(value="mappingCode") String mappingCode, @RequestParam(value="fieldCode") String[] fieldCodes, @RequestParam(name="nullable", required=false) Boolean[] nullables, @RequestParam(name="groupIndex", required=false) String[] groupIndexs) {
        try {
            if (nullables == null) {
                nullables = new Boolean[]{};
            }
            if (groupIndexs == null) {
                groupIndexs = new String[]{};
            }
            this.dynamicFormFieldMappingService.rebinding(dynamicFormCode, mappingCode, (List)Lists.newArrayList((Object[])fieldCodes), (List)Lists.newArrayList((Object[])nullables));
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

