/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.local.init;

import com.biz.crm.common.form.sdk.model.DynamicForm;
import com.biz.crm.common.form.sdk.model.OperationStrategy;
import com.biz.crm.common.form.sdk.module.ModuleRegister;
import com.biz.crm.common.form.sdk.widget.WidgetKey;
import com.bizunited.nebula.init.service.InitProcessEnvironmentService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DynamicFormInitProcess
implements InitProcessEnvironmentService {
    private static final Logger log = LoggerFactory.getLogger(DynamicFormInitProcess.class);
    @Autowired(required=false)
    private List<ModuleRegister> moduleRegisters;
    @Autowired(required=false)
    private List<OperationStrategy<? extends DynamicForm>> operationStrateis;
    @Autowired
    private List<WidgetKey> widgetKeys;

    public boolean doInitForAppCode(String appCode) {
        return StringUtils.equals((CharSequence)appCode, (CharSequence)"default");
    }

    public void initForAppCode(String appCode) {
        if (CollectionUtils.isEmpty(this.moduleRegisters)) {
            log.error("\u52a8\u6001\u8868\u5355\u6a21\u5757\u6ca1\u6709\u53d1\u73b0\u6709\u4efb\u4f55\u6a21\u5757\u6ce8\u518c\u4fe1\u606f(ModuleRegister)!!");
            return;
        }
        if (CollectionUtils.isEmpty(this.operationStrateis)) {
            log.error("\u52a8\u6001\u8868\u5355\u6a21\u5757\u6ca1\u6709\u53d1\u73b0\u6709\u4efb\u4f55\u64cd\u4f5c\u7b56\u7565\u6ce8\u518c\u4fe1\u606f(OperationStrategy)!!");
            return;
        }
        List moduleCodes = this.moduleRegisters.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.moduleCode())).map(ModuleRegister::moduleCode).distinct().collect(Collectors.toList());
        Validate.isTrue((moduleCodes.size() == this.moduleRegisters.size() ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u542f\u52a8\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u6709\u4e00\u4e2aModuleRegister\u63a5\u53e3\u7684\u5b9e\u73b0\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fdd\u8bc1ModuleRegister\u7684\u5404\u4e2a\u5b9e\u73b0\u4e2dmoduleCode\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u552f\u4e00", (Object[])new Object[0]);
        List dynamicFormCodes = this.operationStrateis.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.dynamicFormCode())).map(OperationStrategy::dynamicFormCode).distinct().collect(Collectors.toList());
        Validate.isTrue((dynamicFormCodes.size() == this.operationStrateis.size() ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u542f\u52a8\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u6709\u4e00\u4e2aModuleRegister\u63a5\u53e3\u7684\u5b9e\u73b0\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fdd\u8bc1OperationStrategy\u7684\u5404\u4e2a\u5b9e\u73b0\u4e2ddynamicFormCode\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u552f\u4e00", (Object[])new Object[0]);
        Map<String, OperationStrategy> operationStrategyMapping = this.operationStrateis.stream().collect(Collectors.toMap(OperationStrategy::dynamicFormCode, item -> item));
        Set operationStrategyClassSet = this.operationStrateis.stream().filter(item -> item.dynamicFormClass() != null).map(OperationStrategy::dynamicFormClass).distinct().collect(Collectors.toSet());
        Validate.isTrue((operationStrategyClassSet.size() == this.operationStrateis.size() ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u542f\u52a8\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u6709\u4e00\u4e2aModuleRegister\u63a5\u53e3\u7684\u5b9e\u73b0\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fdd\u8bc1OperationStrategy\u7684\u5404\u4e2a\u5b9e\u73b0\u4e2ddynamicFormClass\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u552f\u4e00", (Object[])new Object[0]);
        for (Map.Entry<String, OperationStrategy> entryItem : operationStrategyMapping.entrySet()) {
            String dynamicFormCode = entryItem.getKey();
            OperationStrategy operationStrategy = entryItem.getValue();
            String moduleCode = operationStrategy.moduleCode();
            Validate.isTrue((boolean)moduleCodes.contains(moduleCode), (String)"OperationStrategy\u63a5\u53e3\u7684\u4e00\u4e2a\u5177\u4f53\u5b9e\u73b0\uff1a%s \u6ca1\u6709\u6b63\u786e\u8bbe\u5b9amoduleCode\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{dynamicFormCode});
        }
        List exsitWidgetKeys = this.widgetKeys.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.widgetCode())).map(WidgetKey::widgetCode).collect(Collectors.toList());
        Validate.isTrue((exsitWidgetKeys.size() == this.widgetKeys.size() ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u542f\u52a8\u65f6\uff0c\u53d1\u73b0\u81f3\u5c11\u6709\u4e00\u4e2aWidgetKey\u63a5\u53e3\u7684\u5b9e\u73b0\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fdd\u8bc1WidgetKey\u7684\u5404\u4e2a\u5b9e\u73b0\u4e2dwidgetCode\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u552f\u4e00", (Object[])new Object[0]);
    }
}

