package com.biz.crm.common.form.sdk.field.validate;

import java.lang.reflect.Field;

import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import com.biz.crm.common.form.sdk.field.ValidateStrategy;

/**
 * 该验证逻辑用于验证指定的字符串性质的字段，不为null或者空字符串。如果验证不通过，则抛出异常。如果字段不是字符串性质的字段，则忽略验证过程
 * @author yinwenjie
 */
@Component
public class NotBlankValidateStrategy implements ValidateStrategy {

  @Override
  public void validate(Object fieldValue, String fieldName, Field field, Object dynamicForm) {
    if(!(fieldValue instanceof CharSequence)) {
      return;
    }
    
    Validate.notBlank((CharSequence)fieldValue, "%s信息不能为空或者空字符，请检查!!" , fieldName);
  }
}
