package com.biz.crm.common.form.sdk.model;

/**
 * XXXX 动态表单的增删改查差操作策略，如果主业务模型涉及到的Map性质抽象字段/属性，其Value部分为单个业务模型（不是任何集合），
 * 那么请使用该接口描述这个动态表单模型的操作策略
 * @author yinwenjie
 */
public interface DynamicFormOperationStrategy<T extends DynamicForm> extends OperationStrategy<T> {
  /**
   * 当主业务模型完成创建动作后，并且要求对应的动态表单进行创建操作时，该动态表单模型的操作策略的onDynamicFormsCreate方法将会被触发   * @param dynamicForms 本次添加操作将进行添加的动态表单数据集合
   * @param parentCode 这些动态表单数据对应上层主业务模型的业务编号
   * @param parent 上层主业务数据
   */  
  public void onDynamicFormCreate(T dynamicForm , String dynamicKey , String parentCode , Object parent);
  /**
   * 当主业务模型完成修改动作后，并且要求对应的动态表单进行修改操作时，该动态表单模型的操作策略的onDynamicFormsModify方法将会被触发
   * @param dynamicForms 本次添加操作将进行添加的动态表单数据集合
   * @param parentCode 这些动态表单数据对应上层主业务模型的业务编号
   * @param parent 上层主业务数据
   */
  public void onDynamicFormModify(T dynamicForm , String dynamicKey , String parentCode , Object parent);
  /**
   * 挡住业务模型完成主信息查询，需要关联完善对应的动态表单数据时，该动态表单模型的操作策略的findByParentCode方法将会被触发
   * @param dynamicKey Map性质的属性/字段，其Key值
   * @param parentCode 这些动态表单数据对应上层主业务模型的业务编号
   * @return
   */
  public T findByParentCode(String dynamicKey , String parentCode);
}
