package com.biz.crm.common.form.sdk;


import java.util.List;

import com.biz.crm.common.form.sdk.vo.DynamicFormVo;

/**
 * TODO 注释未写
 * @author yinwenjie
 */
public interface DynamicFormFieldMappingService {
  /**
   * 按照动态表单在系统中唯一的业务编码进行查询，注意，这种查询方式，将忽略对字段选择范围的过滤。
   * 意思就是说动态表单中所有的业务字段都将被返回
   * @param dynamicFormCode
   * @return
   */
  DynamicFormVo findByDynamicFormCode(String dynamicFormCode);
  
  /**
   * 按照动态表单在系统中唯一的业务编码和为这个表单设置的字段映射编号进行查询</br>
   * 这种查询结果将只会返回这个动态表单中和这个映射编号绑定的字段信息
   * @param dynamicFormCode 
   * @param mappingCode
   * @return
   */
  DynamicFormVo findByDynamicFormCodeAndMappingCode(String dynamicFormCode , String mappingCode);
  
  /**
   * 该方法将建立/重新建立指定动态表单下，基于某个映射编号（可以是任意业务意义的字符串），所绑定的动态表单字段信息</p>
   * 
   * 该方法的工作原则是：</br>
   * 1、dynamicFormCode必须存在</br>
   * 2、mappingCode必须传入</br>
   * 3、fieldCodes区分大小写，并且会自动去重，并且这些去重后的字段必须存在于指定的动态表单模型中
   * 
   * @param dynamicFormCode 必须是一个已经存在的动态表单的编号
   * @param mappingCode 某个映射编号（可以是任意业务意义的字符串）
   * @param fieldCodes 字段英文名，注意，这种情况下，表示所有选定的字段都是非必填
   */
  void rebinding(String dynamicFormCode , String mappingCode , List<String> fieldCodes);
  
  /**
   * 该方法将建立/重新建立指定动态表单下，基于某个映射编号（可以是任意业务意义的字符串），所绑定的动态表单字段信息</p>
   * 
   * 该方法的工作原则是：</br>
   * 1、dynamicFormCode必须存在</br>
   * 2、mappingCode必须传入</br>
   * 3、fieldCodes区分大小写，并且会自动去重，并且这些去重后的字段必须存在于指定的动态表单模型中
   * 
   * @param dynamicFormCode 必须是一个已经存在的动态表单的编号
   * @param mappingCode 某个映射编号（可以是任意业务意义的字符串）
   * @param fieldCodes 字段英文名，注意，这种情况下，表示所有选定的字段都是必填
   * @param nullables 该集合对应fieldCodes中的信息，表示字段是否非必填（true：非必填;false：必填），
   * 注意，只有那些注释设置为非必填的，这里才能设置为true或者false；如果注释设置为必填，则这里的设定值只能是false
   */
  void rebinding(String dynamicFormCode , String mappingCode , List<String> fieldCodes , List<Boolean> nullables);
  
  /**
   * 和其他几个rebinding方法的区别是，这里需要传入一个有序对应fieldCodes中字段信息的排序索引号
   * @param sortIndexs 排序索引号，排序索引号越小的，排序越靠前
   * @param groupIndexs 分组信息，如果要指定，就每个绑定的字段都要指定，如果不指定传入null或者空集合即可。
   */
  void rebinding(String dynamicFormCode , String mappingCode , List<String> fieldCodes , List<Boolean> nullables , List<Integer> sortIndexs , List<String> groupIndexs);
}
