package com.biz.crm.common.form.sdk.codec;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;

import org.springframework.util.CollectionUtils;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.biz.crm.common.form.sdk.widget.WidgetKey;

/**
 * 注意：DynamicForm对象的值，不允许从JSON转换而来，所以无需实现ObjectDeserializer接口
 * @author yinwenjie
 */
public class WidgetKeyCodec  implements ObjectSerializer {

  public final static WidgetKeyCodec instance = new WidgetKeyCodec();
  
  @Override
  public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
    SerializeWriter out = serializer.out;
    // 如果为null，就不进行转换
    if (object == null) {
      out.writeNull();
      return;
    }
    
    // 如果需要转换就转换为一段由widgetCode、widgetName、和widgetParam组合构建的JSON字符串
    WidgetKey widgetKey = (WidgetKey)object;
    String widgetCode = widgetKey.widgetCode();
    String widgetName = widgetKey.widgetName();
    Map<String , Object> params = widgetKey.widgetParam();
    
    out.writeFieldValue('{', "widgetCode", widgetCode);
    out.writeFieldValue(',', "widgetName", widgetName);
    if(CollectionUtils.isEmpty(params)) {
      for (Map.Entry<String,Object> paramItem : params.entrySet()) {
        String key = paramItem.getKey();
        Object value = paramItem.getValue();
        if(value != null) {
          out.writeFieldValue(',', key, value.toString());
        }
      }
    }
    out.write('}');
  }
}
