package com.biz.crm.common.form.sdk.field.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.biz.crm.common.form.sdk.widget.WidgetKey;

/**
 * 动态表单中，一个既定的字段信息
 * @author yinwenjie
 */
@Documented
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface DynamicField {
  
  /**
   * 字段的中文说明（这个中文说明，将可以展示在前端页面上）
   * @return
   */
  String fieldName();
  /**
   * 字段在页面上使用的控件信息（控件的唯一标识），
   * 请使用已有的控件类型描述类
   */
  Class<? extends WidgetKey> controllKey();
  /**
   * 字段在前端页面上，是否必填
   */
  boolean required() default true;
  /**
   * 字段信息在前端页面是否允许修改
   */
  boolean modifiable() default true;
  /**
   * 字段使用的验证策略，验证策略将在前端传来的json信息形成对象后，紧接着进行每个字段的验证策略执行</p>
   * 如果需要进行过个验证策略的验证，则可以设定多个。
   * @return
   */
  Validate[] validates() default {};
}
