package com.biz.crm.common.form.sdk.vo;

import java.util.List;

/**
 * 这个接口，有助于进行树的递归遍历
 * @author yinwenjie
 *
 */
public interface IDynamicForm {
  /**
   * 该动态表单结构中的动态字段信息（注意，只有使用了DynamicField注解的，由开发人员定义的字段，才是动态字段）
   */
  public List<DynamicFieldVo> getDynamicFields();
  /**
   * 设置本层级表单的动态字段信息
   * @return
   */
  public void setDynamicFields(List<DynamicFieldVo> dynamicFields);
  /**
   * 该子级结构中的下级子级明细结构</br>
   * 注意，结构关联的字段，一定是collection集合
   */
  public List<DynamicChildrenFormVo> getChildrenForms();
  /**
   * 设定本层级表单的下级表单情况
   * @param childrenForms
   */
  public void setChildrenForms(List<DynamicChildrenFormVo> childrenForms);
} 
