package com.biz.crm.common.form.simple.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.common.form.sdk.field.annotation.DynamicField;
import com.biz.crm.common.form.sdk.field.annotation.Validate;
import com.biz.crm.common.form.sdk.field.validate.NotBlankValidateStrategy;
import com.biz.crm.common.form.sdk.widget.SimpleInputWidget;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Transient;
import java.util.List;

/**
 * 竞品采集表
 *
 * @author songjingen
 * @date 2022/6/8
 */
@Getter
@Setter
@ApiModel(value = "CompetingGoodsCollect", description = "竞品采集表")
public class CompetingGoodsCollect {

  /**
   * 采集编码
   */
  @ApiModelProperty("采集编码")
  @Column(name = "collect_code", length = 64, nullable = false, columnDefinition = "VARCHAR(64) COMMENT '采集编码'")
  private String collectCode;

  /**
   * 活动信息
   */
  @ApiModelProperty("活动信息")
  @Column(name = "action_info", length = 200, nullable = false, columnDefinition = "VARCHAR(128) COMMENT '活动信息'")
  @DynamicField(fieldName = "活动信息", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private String actionInfo;

  /**
   * 竞品清单集合
   */
  @Transient
  @TableField(exist = false)
  @ApiModelProperty("竞品清单集合")
  @DynamicField(fieldName = "竞品清单集合", validates = {@Validate(value = NotBlankValidateStrategy.class)}, controllKey = SimpleInputWidget.class)
  private List<CompetingGoodsCollectInventory> inventories;

}
