package com.biz.crm.common.form.simple.strategy;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.biz.crm.common.form.sdk.model.DynamicFormsOperationStrategy;
import com.biz.crm.common.form.simple.vo.OrgCustomer;
import com.google.common.collect.Lists;

/**
 * 专门为具体的OrgCustomer业务模型服务的操作策略
 * @author yinwenjie
 */
@Component("dynamicFormsOperationStrategyForOrgCustomer")
public class DynamicFormsOperationStrategyForOrgCustomer implements DynamicFormsOperationStrategy<OrgCustomer> {

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormsOperationStrategyForOrgCustomer.class);
  
  @Override
  public int getOrder() {
    return 9;
  }
  
  @Override
  public String dynamicFormCode() {
    return "dynamicFormsOperationStrategyForOrgCustomer";
  }

  @Override
  public String dynamicFormName() {
    return "政府客户编目";
  }

  @Override
  public Class<OrgCustomer> dynamicFormClass() {
    return OrgCustomer.class;
  }

  @Override
  public String moduleCode() {
    // 参见com.biz.crm.common.form.simple.config.SimpleModuleRegister
    return "computerModuleRegister";
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
    LOGGER.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
  }

  @Override
  public void onDynamicFormsCreate(Collection<OrgCustomer> dynamicForms, String dynamicKey, String parentCode, Object parent) {
    LOGGER.info("onDynamicFormsCreate");
  }

  @Override
  public void onDynamicFormsModify(Collection<OrgCustomer> dynamicForms, String dynamicKey, String parentCode, Object parent) {
    LOGGER.info("onDynamicFormsModify");
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey, String[] detailCodes) {
    LOGGER.info("onDynamicFormsDelete");
  }

  @Override
  public Collection<OrgCustomer> findByParentCode(String dynamicKey, String parentCode) {
    LOGGER.info("findByParentCode");
    
    // 这里是测试数据
    List<OrgCustomer> orgCustomers = Lists.newArrayList();
    OrgCustomer orgCustomer = new OrgCustomer();
    orgCustomer.setDynamicKey(dynamicKey);
    orgCustomer.setParentCode(parentCode);
    orgCustomer.setDiscount(new BigDecimal(9.5));
    orgCustomer.setOrgName("orgName");
    orgCustomer.setPaymentType(1);
    orgCustomers.add(orgCustomer);
    return orgCustomers;
  }

}
