package com.biz.crm.common.form.simple.strategy;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.common.form.simple.vo.CpuAccessory;

/**
 * 专门为具体的CpuAccessory业务模型服务的操作策略
 * @author yinwenjie
 */
@Component("dynamicFormOperationStrategyForCpuAccessory")
public class DynamicFormOperationStrategyForCpuAccessory implements DynamicFormOperationStrategy<CpuAccessory> {

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormOperationStrategyForCpuAccessory.class);
  
  @Override
  public int getOrder() {
    return 9;
  }
  
  @Override
  public String dynamicFormCode() {
    return "dynamicFormOperationStrategyForCpuAccessory";
  }

  @Override
  public String dynamicFormName() {
    return "CPU型号编目";
  }

  @Override
  public Class<CpuAccessory> dynamicFormClass() {
    return CpuAccessory.class;
  }

  @Override
  public String moduleCode() {
    // 参见com.biz.crm.common.form.simple.config.SimpleModuleRegister
    return "computerModuleRegister";
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
    LOGGER.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
  }

  @Override
  public void onDynamicFormCreate(CpuAccessory dynamicForm, String dynamicKey, String parentCode,Object parent) {
    /*
     * 该方法中，进行每一个具体CpuAccessory信息保存
     * 注意：
     * 1、正式进行保存前，一定要根据业务进行具体的验证
     * 2、dynamicKey和parentCode，必须要保存下来，否则后续从持久层读取的数据找不到对应关系
     * */
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    LOGGER.info("onDynamicFormCreate(CpuAccessory dynamicForm, String dynamicKey, String parentCode,Object parent)");
  }

  @Override
  public void onDynamicFormModify(CpuAccessory dynamicForm, String dynamicKey, String parentCode, Object parent) {
    /*
     * 该方法，机型每一个具体CpuAccessory信息的修改
     * 注意：
     * 1、正式进行保存前，一定要根据业务进行具体的验证
     * 2、dynamicKey和parentCode，必须要保存下来，否则后续从持久层读取的数据找不到对应关系
     * */
    dynamicForm.setParentCode(parentCode);
    dynamicForm.setDynamicKey(dynamicKey);
    LOGGER.info("onDynamicFormModify(CpuAccessory dynamicForm, String dynamicKey, String parentCode, Object parent)");
  }

  @Override
  public CpuAccessory findByParentCode(String dynamicKey, String parentCode) {
    LOGGER.info("findByParentCode(String dynamicKey(" + dynamicKey + "), String parentCode[" + parentCode + "])");
    
    // 这里是测试数据
    CpuAccessory cpuAccessory = new CpuAccessory();
    cpuAccessory.setParentCode(parentCode);
    cpuAccessory.setDynamicKey(dynamicKey);
    cpuAccessory.setOriginCode("originCode");
    cpuAccessory.setSerial("serial");
    cpuAccessory.setType(1);
    return cpuAccessory;
  }
}
