package com.biz.crm.common.form.simple.strategy;

import java.util.Date;

import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import com.biz.crm.common.form.sdk.model.DynamicFormOperationStrategy;
import com.biz.crm.common.form.simple.vo.MemoryAccessory;

/**
 * 专门为具体的CpuAccessory业务模型服务的操作策略 </p>
 * 
 * 请注意该示例代码包中，分别实现DynamicFormOperationStrategy接口或者DynamicFormsOperationStrategy接口的区别
 * 
 * @author yinwenjie
 */
@Component("dynamicFormOperationStrategyForMemoryAccessory")
public class DynamicFormOperationStrategyForMemoryAccessory implements DynamicFormOperationStrategy<MemoryAccessory> {

  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormOperationStrategyForMemoryAccessory.class);
  
  @Override
  public int getOrder() {
    return 9;
  }
  
  @Override
  public String dynamicFormCode() {
    return "dynamicFormOperationStrategyForMemoryAccessory";
  }

  @Override
  public String dynamicFormName() {
    return "内存型号编目";
  }

  @Override
  public Class<MemoryAccessory> dynamicFormClass() {
    return MemoryAccessory.class;
  }

  @Override
  public String moduleCode() {
    // 参见com.biz.crm.common.form.simple.config.SimpleModuleRegister
    return "computerModuleRegister";
  }

  @Override
  public void onDynamicFormsDelete(String parentCode, String dynamicKey) {
    LOGGER.info("onDynamicFormsDelete(String parentCode, String dynamicKey)");
  }

  @Override
  public void onDynamicFormCreate(MemoryAccessory dynamicForm, String dynamicKey, String parentCode,Object parent) {
    // 请参见DynamicFormOperationStrategyForCpuAccessory
    LOGGER.info("onDynamicFormCreate(CpuAccessory dynamicForm, String dynamicKey, String parentCode,Object parent)");
  }

  @Override
  public void onDynamicFormModify(MemoryAccessory dynamicForm, String dynamicKey, String parentCode, Object parent) {
    // 请参见 DynamicFormOperationStrategyForCpuAccessory
    LOGGER.info("onDynamicFormModify(CpuAccessory dynamicForm, String dynamicKey, String parentCode, Object parent)");
  }

  @Override
  public MemoryAccessory findByParentCode(String dynamicKey, String parentCode) {
    LOGGER.info("findByParentCode(String dynamicKey(" + dynamicKey + "), String parentCode[" + parentCode + "])");
    
    // 这里是测试数据
    MemoryAccessory memoryAccessory = new MemoryAccessory();
    memoryAccessory.setDynamicKey(dynamicKey);
    memoryAccessory.setParentCode(parentCode);
    memoryAccessory.setExpireTime(DateUtils.addDays(new Date(), 5));
    memoryAccessory.setHz("hz");
    memoryAccessory.setSerial("serial");
    return memoryAccessory;
  }
}
