package com.biz.crm.common.form.simple.controller;

import java.util.UUID;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.DynamicFormServiceBuilder;
import com.biz.crm.common.form.simple.vo.ComputerVo;

import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@RestController
@RequestMapping(value = {"/v1/dynamicform/computers"})
public class ComputerVoController {

  @Autowired
  private ApplicationContext applicationContext;

  @SuppressWarnings("unchecked")
  @ApiOperation(value = "主业务表单信息进行添加")
  @PostMapping(value = "")
  public Result<?> create(@RequestBody JSONObject computerJsonObject) {
    try {
      DynamicFormServiceBuilder<ComputerVo> dynamicFormServiceBuilder = 
          applicationContext.getBean(DynamicFormServiceBuilder.class , ComputerVo.class , this.applicationContext);
      // 设定第一个动态表单所依据的主业务模型字段（），
      // 在正式业务编写中，可以使用业务模板（例如：拜访过程模板）记录dynamicKey和动态表单dynamicFormCode之间的对应关系
      DynamicFormService<ComputerVo> dynamicFormService =
      dynamicFormServiceBuilder.dynamicField("accessors")
        .addDynamicMapping("dynamicKey1", "dynamicFormOperationStrategyForCpuAccessory")
        .addDynamicMapping("dynamicKey2", "dynamicFormOperationStrategyForMemoryAccessory")
        .config()
      // 设定第二个动态表单所依据的主业务模型字段
      // 多组key所使用的模板可能是一样的，例如 五月-预算科目、六月预算科目，使用的动态表单模板都是同样一个
      .dynamicField("customerMapping")
        .addDynamicMapping("dynamicKey3", "dynamicFormsOperationStrategyForOrgCustomer")
        .addDynamicMapping("dynamicKey4", "dynamicFormsOperationStrategyForOrgCustomer")
        .config()
      .build();
      
      // 建立完服务对象后，就可以进行主业务下的动态表单数据的处理了
      // 首先使用转化器，完成json信息到vo的转换
      ComputerVo currentComputer = dynamicFormService.dynamic(computerJsonObject);
      
      // 接着模拟对主业务数据的保存，正式环境这些代码都必须放置于service中
      // 这里通过模拟一个uuid的生成，来当做主业务数据保存成功
      String parentCode = UUID.randomUUID().toString();
      
      // 接着开始保存主业务数据中的各种动态表单数据
      currentComputer.setCode(parentCode);
      dynamicFormService.createDynamicDetails(currentComputer, parentCode);
      return Result.ok();
    } catch(RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  @SuppressWarnings("unchecked")
  @ApiOperation(value = "查询电脑详情信息，包括所有的关联信息")
  @GetMapping(value = "findByComputerCode")
  public Result<ComputerVo> findByComputerCode(@RequestParam("computerCode") String computerCode) {
    try {
      // 首先应该查询主业务单据上的基本信息，这里写死进行处理
      ComputerVo computerVo = new ComputerVo();
      computerVo.setCode(computerCode);
      computerVo.setName("测试用的电脑详情信息");
      
      DynamicFormServiceBuilder<ComputerVo> dynamicFormServiceBuilder = applicationContext.getBean(DynamicFormServiceBuilder.class , ComputerVo.class , this.applicationContext);
      // 设定第一个动态表单所依据的主业务模型字段（），
      // 在正式业务编写中，可以使用业务模板（例如：拜访过程模板）记录dynamicKey和动态表单dynamicFormCode之间的对应关系
      DynamicFormService<ComputerVo> dynamicFormService =
      dynamicFormServiceBuilder.dynamicField("accessors")
        .addDynamicMapping("dynamicKey1", "dynamicFormOperationStrategyForCpuAccessory")
        .addDynamicMapping("dynamicKey2", "dynamicFormOperationStrategyForMemoryAccessory")
        .config()
      // 设定第二个动态表单所依据的主业务模型字段
      // 多组key所使用的模板可能是一样的，例如 五月-预算科目、六月预算科目，使用的动态表单模板都是同样一个
      .dynamicField("customerMapping")
        .addDynamicMapping("dynamicKey3", "dynamicFormsOperationStrategyForOrgCustomer")
        .addDynamicMapping("dynamicKey4", "dynamicFormsOperationStrategyForOrgCustomer")
        .config()
      .build();
      
      // 开始做动态表单数据的详情查询
      dynamicFormService.perfectDynamicDetails(computerVo, computerCode);
      return Result.ok(computerVo); 
    } catch(RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
