/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.form.simple.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.DynamicFormServiceBuilder;
import com.biz.crm.common.form.simple.vo.ComputerVo;
import io.swagger.annotations.ApiOperation;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dynamicform/computers"})
public class ComputerVoController {
    private static final Logger log = LoggerFactory.getLogger(ComputerVoController.class);
    @Autowired
    private ApplicationContext applicationContext;

    @ApiOperation(value="\u4e3b\u4e1a\u52a1\u8868\u5355\u4fe1\u606f\u8fdb\u884c\u6dfb\u52a0")
    @PostMapping(value={""})
    public Result<?> create(@RequestBody JSONObject computerJsonObject) {
        try {
            DynamicFormServiceBuilder dynamicFormServiceBuilder = (DynamicFormServiceBuilder)this.applicationContext.getBean(DynamicFormServiceBuilder.class, new Object[]{ComputerVo.class, this.applicationContext});
            DynamicFormService dynamicFormService = dynamicFormServiceBuilder.dynamicField("accessors").addDynamicMapping("dynamicKey1", "dynamicFormOperationStrategyForCpuAccessory").addDynamicMapping("dynamicKey2", "dynamicFormOperationStrategyForMemoryAccessory").config().dynamicField("customerMapping").addDynamicMapping("dynamicKey3", "dynamicFormsOperationStrategyForOrgCustomer").addDynamicMapping("dynamicKey4", "dynamicFormsOperationStrategyForOrgCustomer").config().build();
            ComputerVo currentComputer = (ComputerVo)dynamicFormService.dynamic(computerJsonObject);
            String parentCode = UUID.randomUUID().toString();
            currentComputer.setCode(parentCode);
            dynamicFormService.createDynamicDetails((Object)currentComputer, parentCode);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7535\u8111\u8be6\u60c5\u4fe1\u606f\uff0c\u5305\u62ec\u6240\u6709\u7684\u5173\u8054\u4fe1\u606f")
    @GetMapping(value={"findByComputerCode"})
    public Result<ComputerVo> findByComputerCode(@RequestParam(value="computerCode") String computerCode) {
        try {
            ComputerVo computerVo = new ComputerVo();
            computerVo.setCode(computerCode);
            computerVo.setName("\u6d4b\u8bd5\u7528\u7684\u7535\u8111\u8be6\u60c5\u4fe1\u606f");
            DynamicFormServiceBuilder dynamicFormServiceBuilder = (DynamicFormServiceBuilder)this.applicationContext.getBean(DynamicFormServiceBuilder.class, new Object[]{ComputerVo.class, this.applicationContext});
            DynamicFormService dynamicFormService = dynamicFormServiceBuilder.dynamicField("accessors").addDynamicMapping("dynamicKey1", "dynamicFormOperationStrategyForCpuAccessory").addDynamicMapping("dynamicKey2", "dynamicFormOperationStrategyForMemoryAccessory").config().dynamicField("customerMapping").addDynamicMapping("dynamicKey3", "dynamicFormsOperationStrategyForOrgCustomer").addDynamicMapping("dynamicKey4", "dynamicFormsOperationStrategyForOrgCustomer").config().build();
            dynamicFormService.perfectDynamicDetails((Object)computerVo, computerCode);
            return Result.ok((Object)computerVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

