package com.biz.crm.common.gaode.local.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.gaode.sdk.constant.GaoDeConstant;
import com.biz.crm.common.gaode.sdk.dto.QueryAroundDto;
import com.biz.crm.common.gaode.sdk.service.GaoDeAroundService;
import com.biz.crm.common.gaode.sdk.vo.GaoDeNearbyVo;
import com.biz.crm.common.gaode.sdk.vo.GaoDeResponseVo;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * 高德
 *
 * @author songjingen
 */
@Service
@Slf4j
public class GaoDeAroundServiceImpl implements GaoDeAroundService {

  @Value("${gaode.key:}")
  private String key;
  @Value("${gaode.radius:}")
  private String radius;

  @Value("${gaode.keywords:}")
  private String keywords;

  @Autowired
  @Qualifier("restTemplateRemote")
  private RestTemplate restTemplate;

  @Override
  public Page<GaoDeNearbyVo> findByConditions(QueryAroundDto dto) {
    if (StringUtils.isBlank(dto.getRadius())) {
      dto.setRadius(radius);
    }
    if (StringUtils.isBlank(dto.getKeywords())) {
      dto.setKeywords(keywords);
    }
    if (StringUtils.isBlank(key)
        || StringUtils.isBlank(dto.getRadius())
        || StringUtils.isBlank(dto.getKeywords())
    ) {
      throw new RuntimeException("请维护高德相关参数");
    }
    Map<String, String> uriVariables = new HashMap<>();
    StringBuffer url = new StringBuffer();
    url.append(GaoDeConstant.aroundUrl).append("?key=").append(key);
    url.append("&").append("location=").append(dto.getLocation());
    url.append("&").append("radius=").append(dto.getRadius());
    url.append("&").append("keywords=").append(dto.getKeywords());
    url.append("&").append("extensions=").append("all");
    url.append("&").append("offset=").append(dto.getOffset());
    url.append("&").append("page=").append(dto.getPage());
    log.info("请求高德附近门店url==> " + url.toString());
    ResponseEntity<String> resVoResponseEntity = restTemplate.getForEntity(url.toString(), String.class, uriVariables);
    String strRes = resVoResponseEntity.getBody();
    log.info("请求高德附近门店返回参数 ==> " + strRes);
    strRes = strRes.replaceAll("\"tel\":\\[]", "\"tel\":\"\"");
    strRes = strRes.replaceAll("\"address\":\\[]", "\"address\":\"\"");
    GaoDeResponseVo gaoDeResponseVo = JsonUtils.json2Obj(strRes, GaoDeResponseVo.class);
    Page<GaoDeNearbyVo> page = new Page<>();
    page.setTotal(Long.parseLong(gaoDeResponseVo.getCount()));
    page.setCurrent(Long.parseLong(dto.getPage()));
    page.setSize(Long.parseLong(dto.getOffset()));
    page.setRecords(gaoDeResponseVo.getPois());
    return page;
  }
}
