package com.biz.crm.common.gaode.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 附近门店信息
 *
 * @author songjingen
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "门店根据条件查询返回VO ")
public class GaoDeNearbyVo implements java.io.Serializable {
  private static final long serialVersionUID = 1712768101421689700L;
  @ApiModelProperty("经纬度")
  private String location;
  @ApiModelProperty("经度")
  private String longitude;
  @ApiModelProperty("纬度")
  private String latitude;
  @ApiModelProperty("名字")
  private String name;
  @ApiModelProperty("省")
  private String pname;
  @ApiModelProperty("省编码")
  private String pcode;
  @ApiModelProperty("市")
  private String cityname;
  @ApiModelProperty("市编码")
  private String citycode;
  @ApiModelProperty("区")
  private String adname;
  @ApiModelProperty("区编码")
  private String adcode;
  @ApiModelProperty("地址")
  private String address;
  @ApiModelProperty("详细地址")
  private String addressDetail;
  @ApiModelProperty("高德唯一值")
  private String id;
  @ApiModelProperty("高德兴趣点类型")
  private String type;
  @ApiModelProperty("高德兴趣点类型编码")
  private String typecode;
  @ApiModelProperty("电话")
  private String tel;
  @ApiModelProperty("图片")
  private List<GaoDePhotos> photos;
  @ApiModelProperty("距离")
  private String distance;

  public String getLongitude() {
    if (StringUtils.isNotEmpty(location)) {
      longitude = location.split(",")[0];
    }
    return longitude;
  }

  public String getLatitude() {
    if (StringUtils.isNotEmpty(location)) {
      latitude = location.split(",")[1];
    }
    return latitude;
  }
}
