package com.biz.crm.business.common.transform;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.identity.DistributorVisitorDetails;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.bizunited.nebula.security.sdk.transform.IdentityTransformStrategy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * 【游客】CRM系统经销商用户体系（EMS+SFA小程序等）boot，在收到携带了JWT信息的请求后，如果发现源信息中用户身份标识sourceIdentityType为c，则通过JSON信息自行转换
 * @author yinwenjie pengxi
 */
@Component("VisitorToVisitorTransformStrategy")
public class VisitorToVisitorTransformStrategy implements IdentityTransformStrategy {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(VisitorToVisitorTransformStrategy.class);
  
  @Override
  public boolean matched(String sourceIdentityType) {
    // u-企业用户，c-客户用户，cv-游客类型的客户，terminal-终端用户，customer_employee-经销商员工用户</br>
    return StringUtils.equals("cv", sourceIdentityType);
  }

  @Override
  public UserIdentity transform(String sourceIdentityType, String sourceTenantCode, String sourceAccount, JSONObject userObject) {
    LOGGER.info("========= VisitorToVisitorTransformStrategy transform : " + sourceIdentityType + "  " + sourceAccount);
    // 转换成经销商游客自身
    DistributorVisitorDetails distributorVisitorDetails = JSONObject.toJavaObject(userObject, DistributorVisitorDetails.class);
    return distributorVisitorDetails;
  }

  @Override
  public int getOrder() {
    // 默认转换策略，最后一个执行
    return Integer.MAX_VALUE;
  }

}
