package com.biz.crm.business.common.identity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;

/**
 * 承载经销商用户的登录信息</p>
 */
@Getter
@Setter
public class DistributorUserDetails extends AbstractCrmUserIdentity {
  private static final long serialVersionUID = -6785761636962732932L;
  /**
   * 企业组织编码
   */
  private String orgCode;
  /**
   * 企业组织名称
   */
  private String orgName;
  /**
   * 客户组织编码
   */
  @ApiModelProperty("客户组织编码")
  private String customerOrgCode;
  /**
   * 客户组织名称
   */
  @ApiModelProperty("客户组织名称")
  private String customerOrgName;
  /**
   * 语言
   */
  private String language;
  /**
   * 客户编码
   */
  private String customerCode;
  /**
   * 客户名称
   */
  private String customerName;
  /**
   * 来源类型
   */
  private String fromType;

  /**
   * openid 微信openid 或者支付宝 用户id
   */
  private String openId;

  @Override
  public String getPostCode() {
    // 经销商从业务上来说，是没有岗位的
    return "customer";
  }

  @Override
  public String getPostName() {
    // 经销商从业务上来说，是没有岗位的
    return "客户";
  }

}
