package com.biz.crm.business.common.identity;

import lombok.Getter;
import lombok.Setter;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;

import java.util.List;

/**
 * @author jerry7 yinwenjie
 * @date 2021/8/4 11:11
 * CRM-厂商用户登录信息实体类，实现springframework.security的UserDetails接口，用于获取数据用户登录信息</br>
 * 并由yinwenjie，在2021年-08-15做出设计变化
 */
@Getter
@Setter
public class FacturerUserDetails extends AbstractCrmUserIdentity {
  private static final long serialVersionUID = -8793810512026511424L;
  /**
   * 可能的电话信息
   */
  private String phone;
  /**
   * 岗位编码
   */
  private String postCode;
  /**
   * 岗位名称
   */
  private String postName;
  /**
   * 组织编码
   */
  private String orgCode;
  /**
   * 组织名称
   */
  private String orgName;
  /**
   * 语言
   */
  private String language;
  /**
   * 来源类型
   */
  private String fromType;

  /**
   * openid 微信openid 或者支付宝 用户id
   */
  private String openId;

  /**
   * 当前用户所有岗位编码集合
   */
  private List<String> postCodes;

  /**
   * 当前用户所有下级岗位编码集合
   */
  private List<String> childrenPostCodes;
}
