package com.biz.crm.common.ie.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import lombok.Data;

/**
 * 导出任务创建dto
 *
 * @author sunx
 * @date 2022/5/19
 */
@Data
@ApiModel(value = "CreateExportTaskDto", description = "导出任务创建dto")
public class CreateExportTaskDto {
  /** 导出业务编码 */
  @ApiModelProperty("导出业务编码")
  private String businessCode;
  /** 文件来源 */
  @ApiModelProperty("文件来源")
  private String taskSource;
  /**
   * 数据权限控制所需要的，由head信息携带的MARS_LIST_CODE
   */
  @ApiModelProperty("数据权限控制所需要的，由head信息携带的MARS_LIST_CODE")
  private String marsListCode;
  /** 参数 */
  @ApiModelProperty("参数")
  private Map<String, Object> params;
}
