package com.biz.crm.common.ie.sdk.excel.process;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 导入基座
 *
 * @author sunx
 * @date 2022/5/12
 */
public interface ImportProcess<T extends CrmExcelVo> {

  /**
   * 单次缓存的数量
   *
   * @return
   */
  default Integer getBatchCount() {
    return 1;
  }

  /**
   * 数据处理
   *
   * @param data 待处理的数据集合，k-流水号，v-excel解析后的对象
   * @param paramsVo 任务公共参数
   * @param params 导入任务自定义参数
   * @return k-对应data的k，v-对应data的k对应的v处理异常描述信息，会回写到错误文件
   */
  Map<Integer, String> execute(
      LinkedHashMap<Integer, T> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params);

  /**
   * 获取数据实体
   *
   * @return
   */
  Class<T> findCrmExcelVoClass();

  /**
   * 获取业务编码(一个业务场景多模板情况,不设置默认取模板编码)
   *
   * @return
   */
  default String getBusinessCode() {
    return CharSequenceUtil.EMPTY;
  }

  /**
   * 业务名称(一个业务场景多模板情况,不设置默认取模板名称)
   *
   * @return
   */
  default String getBusinessName() {
    return CharSequenceUtil.EMPTY;
  }

  /**
   * 获取业务对应的模板编码，全局唯一
   *
   * @return
   */
  String getTemplateCode();

  /**
   * 获取业务对应的模板描述
   *
   * @return
   */
  String getTemplateName();

  /**
   * 前端下拉显示顺序(升序)
   *
   * @return
   */
  default int order() {
    return 0;
  }

  /**
   * 获取用户自定义任务扩展参数（在新建导入任务的时候使用，如果实现会将返回数据存入任务数据库）
   *
   * @return
   */
  default Map<String, Object> getGlobalParams() {
    Map<String, Object> map = Maps.newHashMap();
    map.put(
        ImportExportConstant.IE_PARAMS_CREATE_TIME,
        DateUtil.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
    return map;
  }
}
