package com.biz.crm.common.ie.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 导出任务分页查询dto
 *
 * @author sunx
 * @date 2022-05-18 16:31:52
 */
@Data
@ApiModel(value = "ExportTaskPaginationDto", description = "导出任务分页查询dto")
public class ExportTaskPaginationDto {

  /** 导入任务编码 */
  @ApiModelProperty("导入任务编码")
  private String taskCode;

  /** 任务名称 */
  @ApiModelProperty("任务名称")
  private String taskName;

  /** 文件来源 */
  @ApiModelProperty("文件来源")
  private String taskSource;

  /** 任务执行状态 */
  @ApiModelProperty("任务执行状态")
  private String execStatus;

  /** 任务加载状态 */
  @ApiModelProperty("任务加载状态")
  private String loadStatus;

  /** 应用 */
  @ApiModelProperty("应用")
  private String applicationName;

  /** 顶级租户编码 */
  @ApiModelProperty("顶级租户编码")
  private String appCode;

  /** 租户编码 */
  @ApiModelProperty("租户编码")
  private String tenantCode;
  /**
   * 数据权限控制所需要的，由head信息携带的MARS_LIST_CODE
   */
  @ApiModelProperty("数据权限控制所需要的，由head信息携带的MARS_LIST_CODE")
  private String marsListCode;

  /** 创建开始时间 */
  @ApiModelProperty(name = "createStartTime", value = "创建开始时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createStartTime;

  /** 创建结束时间 */
  @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createEndTime;
}
