package com.biz.crm.common.ie.sdk.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 导出阶段枚举（主任务）
 *
 * @author sunx
 * @date 2022/5/16
 */
@AllArgsConstructor
@Getter
public enum ExportProcessEnum {
  /** 导出阶段枚举 */
  ASYNC_GET_TOTAL("async_get_total", "异步获取", "异步获取任务总数"),
  START("start", "开始", "任务开始执行......"),
  RUNNING("running", "任务处理中", "任务处理中......"),
  COMBINE("combine", "文件合并", "文件合并中……"),
  UPLOAD("upload", "文件上传", "主任务文件上传中……"),
  END("end", "完成", "导出完成"),
  ;
  /** code */
  private String code;
  /** 字典编码 */
  private String desc;
  /** 消息格式 */
  private String format;
}
